/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.climate;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.climate.Supplier;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.climate.SupplierListParams;
import com.stripe.param.climate.SupplierRetrieveParams;
import java.lang.reflect.Type;

public final class SupplierService
extends ApiService {
    public SupplierService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Supplier retrieve(String supplier, SupplierRetrieveParams params) throws StripeException {
        return this.retrieve(supplier, params, null);
    }

    public Supplier retrieve(String supplier, RequestOptions options) throws StripeException {
        return this.retrieve(supplier, null, options);
    }

    public Supplier retrieve(String supplier) throws StripeException {
        return this.retrieve(supplier, null, null);
    }

    public Supplier retrieve(String supplier, SupplierRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/suppliers/%s", ApiResource.urlEncodeId(supplier));
        return (Supplier)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Supplier.class), options, ApiMode.V1);
    }

    public StripeCollection<Supplier> list(SupplierListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Supplier> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Supplier> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Supplier> list(SupplierListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/suppliers";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Supplier>>(){}.getType(), options, ApiMode.V1);
    }
}

