/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerSessionCreateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CustomerSession
extends ApiResource {
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="components")
    Components components;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static CustomerSession create(Map<String, Object> params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(request, (Type)((Object)CustomerSession.class));
    }

    public static CustomerSession create(CustomerSessionCreateParams params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(CustomerSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(request, (Type)((Object)CustomerSession.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.components, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Components getComponents() {
        return this.components;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setComponents(Components components) {
        this.components = components;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerSession)) {
            return false;
        }
        CustomerSession other = (CustomerSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        Components this$components = this.getComponents();
        Components other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        Components $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static class Components
    extends StripeObject {
        @SerializedName(value="buy_button")
        BuyButton buyButton;
        @SerializedName(value="pricing_table")
        PricingTable pricingTable;

        @Generated
        public BuyButton getBuyButton() {
            return this.buyButton;
        }

        @Generated
        public PricingTable getPricingTable() {
            return this.pricingTable;
        }

        @Generated
        public void setBuyButton(BuyButton buyButton) {
            this.buyButton = buyButton;
        }

        @Generated
        public void setPricingTable(PricingTable pricingTable) {
            this.pricingTable = pricingTable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Components)) {
                return false;
            }
            Components other = (Components)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BuyButton this$buyButton = this.getBuyButton();
            BuyButton other$buyButton = other.getBuyButton();
            if (this$buyButton == null ? other$buyButton != null : !((Object)this$buyButton).equals(other$buyButton)) {
                return false;
            }
            PricingTable this$pricingTable = this.getPricingTable();
            PricingTable other$pricingTable = other.getPricingTable();
            return !(this$pricingTable == null ? other$pricingTable != null : !((Object)this$pricingTable).equals(other$pricingTable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Components;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BuyButton $buyButton = this.getBuyButton();
            result = result * 59 + ($buyButton == null ? 43 : ((Object)$buyButton).hashCode());
            PricingTable $pricingTable = this.getPricingTable();
            result = result * 59 + ($pricingTable == null ? 43 : ((Object)$pricingTable).hashCode());
            return result;
        }

        public static class BuyButton
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BuyButton)) {
                    return false;
                }
                BuyButton other = (BuyButton)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BuyButton;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class PricingTable
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PricingTable)) {
                    return false;
                }
                PricingTable other = (PricingTable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PricingTable;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }
    }
}

