/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TaxId;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerTaxIdCreateParams;
import com.stripe.param.CustomerTaxIdListParams;
import com.stripe.param.CustomerTaxIdRetrieveParams;
import java.lang.reflect.Type;

public final class CustomerTaxIdService
extends ApiService {
    public CustomerTaxIdService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public TaxId delete(String customer, String id) throws StripeException {
        return this.delete(customer, id, null);
    }

    public TaxId delete(String customer, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/tax_ids/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (TaxId)this.request(request, (Type)((Object)TaxId.class));
    }

    public TaxId retrieve(String customer, String id, CustomerTaxIdRetrieveParams params) throws StripeException {
        return this.retrieve(customer, id, params, null);
    }

    public TaxId retrieve(String customer, String id, RequestOptions options) throws StripeException {
        return this.retrieve(customer, id, null, options);
    }

    public TaxId retrieve(String customer, String id) throws StripeException {
        return this.retrieve(customer, id, null, null);
    }

    public TaxId retrieve(String customer, String id, CustomerTaxIdRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/tax_ids/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (TaxId)this.request(request, (Type)((Object)TaxId.class));
    }

    public StripeCollection<TaxId> list(String customer, CustomerTaxIdListParams params) throws StripeException {
        return this.list(customer, params, null);
    }

    public StripeCollection<TaxId> list(String customer, RequestOptions options) throws StripeException {
        return this.list(customer, null, options);
    }

    public StripeCollection<TaxId> list(String customer) throws StripeException {
        return this.list(customer, null, null);
    }

    public StripeCollection<TaxId> list(String customer, CustomerTaxIdListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/tax_ids", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<TaxId>>(){}.getType());
    }

    public TaxId create(String customer, CustomerTaxIdCreateParams params) throws StripeException {
        return this.create(customer, params, null);
    }

    public TaxId create(String customer, CustomerTaxIdCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/tax_ids", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (TaxId)this.request(request, (Type)((Object)TaxId.class));
    }
}

