/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Dispute;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.DisputeCloseParams;
import com.stripe.param.DisputeListParams;
import com.stripe.param.DisputeRetrieveParams;
import com.stripe.param.DisputeUpdateParams;
import java.lang.reflect.Type;

public final class DisputeService
extends ApiService {
    public DisputeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Dispute> list(DisputeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Dispute> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Dispute> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Dispute> list(DisputeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Dispute>>(){}.getType());
    }

    public Dispute retrieve(String dispute, DisputeRetrieveParams params) throws StripeException {
        return this.retrieve(dispute, params, null);
    }

    public Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return this.retrieve(dispute, null, options);
    }

    public Dispute retrieve(String dispute) throws StripeException {
        return this.retrieve(dispute, null, null);
    }

    public Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(String dispute, DisputeUpdateParams params) throws StripeException {
        return this.update(dispute, params, null);
    }

    public Dispute update(String dispute, RequestOptions options) throws StripeException {
        return this.update(dispute, null, options);
    }

    public Dispute update(String dispute) throws StripeException {
        return this.update(dispute, null, null);
    }

    public Dispute update(String dispute, DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }

    public Dispute close(String dispute, DisputeCloseParams params) throws StripeException {
        return this.close(dispute, params, null);
    }

    public Dispute close(String dispute, RequestOptions options) throws StripeException {
        return this.close(dispute, null, options);
    }

    public Dispute close(String dispute) throws StripeException {
        return this.close(dispute, null, null);
    }

    public Dispute close(String dispute, DisputeCloseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s/close", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }
}

