/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Refund;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.RefundCancelParams;
import com.stripe.param.RefundCreateParams;
import com.stripe.param.RefundListParams;
import com.stripe.param.RefundRetrieveParams;
import com.stripe.param.RefundUpdateParams;
import java.lang.reflect.Type;

public final class RefundService
extends ApiService {
    public RefundService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Refund> list(RefundListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Refund> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Refund> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Refund> list(RefundListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Refund>>(){}.getType());
    }

    public Refund create(RefundCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Refund create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Refund create() throws StripeException {
        return this.create(null, null);
    }

    public Refund create(RefundCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Refund)this.request(request, (Type)((Object)Refund.class));
    }

    public Refund retrieve(String refund, RefundRetrieveParams params) throws StripeException {
        return this.retrieve(refund, params, null);
    }

    public Refund retrieve(String refund, RequestOptions options) throws StripeException {
        return this.retrieve(refund, null, options);
    }

    public Refund retrieve(String refund) throws StripeException {
        return this.retrieve(refund, null, null);
    }

    public Refund retrieve(String refund, RefundRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Refund)this.request(request, (Type)((Object)Refund.class));
    }

    public Refund update(String refund, RefundUpdateParams params) throws StripeException {
        return this.update(refund, params, null);
    }

    public Refund update(String refund, RequestOptions options) throws StripeException {
        return this.update(refund, null, options);
    }

    public Refund update(String refund) throws StripeException {
        return this.update(refund, null, null);
    }

    public Refund update(String refund, RefundUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Refund)this.request(request, (Type)((Object)Refund.class));
    }

    public Refund cancel(String refund, RefundCancelParams params) throws StripeException {
        return this.cancel(refund, params, null);
    }

    public Refund cancel(String refund, RequestOptions options) throws StripeException {
        return this.cancel(refund, null, options);
    }

    public Refund cancel(String refund) throws StripeException {
        return this.cancel(refund, null, null);
    }

    public Refund cancel(String refund, RefundCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s/cancel", ApiResource.urlEncodeId(refund));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Refund)this.request(request, (Type)((Object)Refund.class));
    }
}

