/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.climate;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.climate.Order;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.climate.OrderCancelParams;
import com.stripe.param.climate.OrderCreateParams;
import com.stripe.param.climate.OrderListParams;
import com.stripe.param.climate.OrderRetrieveParams;
import com.stripe.param.climate.OrderUpdateParams;
import java.lang.reflect.Type;

public final class OrderService
extends ApiService {
    public OrderService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Order> list(OrderListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Order> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Order> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Order> list(OrderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Order>>(){}.getType());
    }

    public Order create(OrderCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order retrieve(String order, OrderRetrieveParams params) throws StripeException {
        return this.retrieve(order, params, null);
    }

    public Order retrieve(String order, RequestOptions options) throws StripeException {
        return this.retrieve(order, null, options);
    }

    public Order retrieve(String order) throws StripeException {
        return this.retrieve(order, null, null);
    }

    public Order retrieve(String order, OrderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(order));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order update(String order, OrderUpdateParams params) throws StripeException {
        return this.update(order, params, null);
    }

    public Order update(String order, RequestOptions options) throws StripeException {
        return this.update(order, null, options);
    }

    public Order update(String order) throws StripeException {
        return this.update(order, null, null);
    }

    public Order update(String order, OrderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(order));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order cancel(String order, OrderCancelParams params) throws StripeException {
        return this.cancel(order, params, null);
    }

    public Order cancel(String order, RequestOptions options) throws StripeException {
        return this.cancel(order, null, options);
    }

    public Order cancel(String order) throws StripeException {
        return this.cancel(order, null, null);
    }

    public Order cancel(String order, OrderCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s/cancel", ApiResource.urlEncodeId(order));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }
}

