/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.issuing.Card;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardDeliverCardParams;
import com.stripe.param.issuing.CardFailCardParams;
import com.stripe.param.issuing.CardReturnCardParams;
import com.stripe.param.issuing.CardShipCardParams;
import java.lang.reflect.Type;

public final class CardService
extends ApiService {
    public CardService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Card deliverCard(String card, CardDeliverCardParams params) throws StripeException {
        return this.deliverCard(card, params, null);
    }

    public Card deliverCard(String card, RequestOptions options) throws StripeException {
        return this.deliverCard(card, null, options);
    }

    public Card deliverCard(String card) throws StripeException {
        return this.deliverCard(card, null, null);
    }

    public Card deliverCard(String card, CardDeliverCardParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/cards/%s/shipping/deliver", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.request(request, (Type)((Object)Card.class));
    }

    public Card failCard(String card, CardFailCardParams params) throws StripeException {
        return this.failCard(card, params, null);
    }

    public Card failCard(String card, RequestOptions options) throws StripeException {
        return this.failCard(card, null, options);
    }

    public Card failCard(String card) throws StripeException {
        return this.failCard(card, null, null);
    }

    public Card failCard(String card, CardFailCardParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/cards/%s/shipping/fail", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.request(request, (Type)((Object)Card.class));
    }

    public Card returnCard(String card, CardReturnCardParams params) throws StripeException {
        return this.returnCard(card, params, null);
    }

    public Card returnCard(String card, RequestOptions options) throws StripeException {
        return this.returnCard(card, null, options);
    }

    public Card returnCard(String card) throws StripeException {
        return this.returnCard(card, null, null);
    }

    public Card returnCard(String card, CardReturnCardParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/cards/%s/shipping/return", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.request(request, (Type)((Object)Card.class));
    }

    public Card shipCard(String card, CardShipCardParams params) throws StripeException {
        return this.shipCard(card, params, null);
    }

    public Card shipCard(String card, RequestOptions options) throws StripeException {
        return this.shipCard(card, null, options);
    }

    public Card shipCard(String card) throws StripeException {
        return this.shipCard(card, null, null);
    }

    public Card shipCard(String card, CardShipCardParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/cards/%s/shipping/ship", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.request(request, (Type)((Object)Card.class));
    }
}

