/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ComponentFinder;
import com.structurizr.analysis.ComponentFinderStrategy;
import com.structurizr.analysis.DefaultTypeRepository;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.TypeCategory;
import com.structurizr.analysis.TypeRepository;
import com.structurizr.analysis.TypeUtils;
import com.structurizr.analysis.TypeVisibility;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractComponentFinderStrategy
implements ComponentFinderStrategy {
    private static final Log log = LogFactory.getLog(AbstractComponentFinderStrategy.class);
    private TypeRepository typeRepository;
    private Set<Component> componentsFound = new HashSet<Component>();
    protected ComponentFinder componentFinder;
    protected List<SupportingTypesStrategy> supportingTypesStrategies = new ArrayList<SupportingTypesStrategy>();

    protected AbstractComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        Arrays.stream(strategies).forEach(this::addSupportingTypesStrategy);
    }

    protected ComponentFinder getComponentFinder() {
        return this.componentFinder;
    }

    @Override
    public void setComponentFinder(ComponentFinder componentFinder) {
        this.componentFinder = componentFinder;
    }

    protected TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Override
    public void beforeFindComponents() {
        this.typeRepository = new DefaultTypeRepository(this.componentFinder.getPackageName(), this.componentFinder.getExclusions(), this.componentFinder.getUrlClassLoader());
        this.supportingTypesStrategies.forEach(sts -> sts.setTypeRepository(this.typeRepository));
    }

    @Override
    public Set<Component> findComponents() {
        this.componentsFound.addAll(this.doFindComponents());
        return this.componentsFound;
    }

    protected abstract Set<Component> doFindComponents();

    @Override
    public void afterFindComponents() {
        this.findSupportingTypes(this.componentsFound);
        this.findDependencies();
    }

    private void findSupportingTypes(Set<Component> components) {
        for (Component component : components) {
            for (CodeElement codeElement : component.getCode()) {
                TypeCategory category;
                TypeVisibility visibility = TypeUtils.getVisibility(this.getTypeRepository(), codeElement.getType());
                if (visibility != null) {
                    codeElement.setVisibility(visibility.getName());
                }
                if ((category = TypeUtils.getCategory(this.getTypeRepository(), codeElement.getType())) == null) continue;
                codeElement.setCategory(category.getName());
            }
            for (SupportingTypesStrategy strategy : this.supportingTypesStrategies) {
                for (Class<?> type : strategy.findSupportingTypes(component)) {
                    TypeCategory category;
                    if (this.isNestedClass(type) || this.componentFinder.getContainer().getComponentOfType(type.getCanonicalName()) != null) continue;
                    CodeElement codeElement = component.addSupportingType(type.getCanonicalName());
                    TypeVisibility visibility = TypeUtils.getVisibility(this.getTypeRepository(), codeElement.getType());
                    if (visibility != null) {
                        codeElement.setVisibility(visibility.getName());
                    }
                    if ((category = TypeUtils.getCategory(this.getTypeRepository(), codeElement.getType())) == null) continue;
                    codeElement.setCategory(category.getName());
                }
            }
        }
    }

    private boolean isNestedClass(Class<?> type) {
        return type != null && type.getName().indexOf(36) > -1;
    }

    private void findDependencies() {
        for (Component component : this.componentFinder.getContainer().getComponents()) {
            for (CodeElement codeElement : component.getCode()) {
                this.addEfferentDependencies(component, codeElement.getType(), new HashSet<String>());
            }
        }
    }

    private void addEfferentDependencies(Component component, String type, Set<String> typesVisited) {
        typesVisited.add(type);
        for (Class<?> referencedType : this.getTypeRepository().findReferencedTypes(type)) {
            try {
                String referencedTypeName = referencedType.getCanonicalName();
                Component destinationComponent = this.componentFinder.getContainer().getComponentOfType(referencedTypeName);
                if (destinationComponent != null) {
                    if (component == destinationComponent) continue;
                    component.uses(destinationComponent, "");
                    continue;
                }
                if (typesVisited.contains(referencedTypeName)) continue;
                this.addEfferentDependencies(component, referencedTypeName, typesVisited);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
        }
    }

    public void addSupportingTypesStrategy(SupportingTypesStrategy supportingTypesStrategy) {
        if (supportingTypesStrategy == null) {
            throw new IllegalArgumentException("A supporting types strategy must be provided.");
        }
        this.supportingTypesStrategies.add(supportingTypesStrategy);
    }

    protected Set<Class<?>> findTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return TypeUtils.findTypesAnnotatedWith(annotation, this.getTypeRepository().getAllTypes());
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology) {
        return this.findClassesWithAnnotation(type, technology, false);
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology, boolean includePublicTypesOnly) {
        HashSet<Component> components = new HashSet<Component>();
        Set<Class<?>> componentTypes = this.findTypesAnnotatedWith(type);
        for (Class<?> componentType : componentTypes) {
            Container container;
            if (includePublicTypesOnly && !Modifier.isPublic(componentType.getModifiers()) || (container = this.getComponentFinder().getContainer()).getComponentWithName(componentType.getSimpleName()) != null) continue;
            components.add(container.addComponent(componentType.getSimpleName(), componentType.getCanonicalName(), "", technology));
        }
        return components;
    }
}

