/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ComponentFinderStrategy;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ComponentFinder {
    private URLClassLoader urlClassLoader;
    private Container container;
    private String packageName;
    private Set<Pattern> exclusions = new HashSet<Pattern>(Arrays.asList(Pattern.compile("java\\..*"), Pattern.compile("javax\\..*"), Pattern.compile("sun\\..*")));
    private List<ComponentFinderStrategy> componentFinderStrategies = new ArrayList<ComponentFinderStrategy>();

    public ComponentFinder(Container container, String packageName, ComponentFinderStrategy ... componentFinderStrategies) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
        if (packageName == null || packageName.trim().length() == 0) {
            throw new IllegalArgumentException("A package name must be specified.");
        }
        if (componentFinderStrategies.length == 0) {
            throw new IllegalArgumentException("One or more ComponentFinderStrategy objects must be specified.");
        }
        this.container = container;
        this.packageName = packageName;
        for (ComponentFinderStrategy componentFinderStrategy : componentFinderStrategies) {
            this.componentFinderStrategies.add(componentFinderStrategy);
            componentFinderStrategy.setComponentFinder(this);
        }
    }

    public Set<Component> findComponents() throws Exception {
        HashSet<Component> componentsFound = new HashSet<Component>();
        for (ComponentFinderStrategy componentFinderStrategy : this.componentFinderStrategies) {
            componentFinderStrategy.beforeFindComponents();
        }
        for (ComponentFinderStrategy componentFinderStrategy : this.componentFinderStrategies) {
            componentsFound.addAll(componentFinderStrategy.findComponents());
        }
        for (ComponentFinderStrategy componentFinderStrategy : this.componentFinderStrategies) {
            componentFinderStrategy.afterFindComponents();
        }
        return componentsFound;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<Pattern> getExclusions() {
        return new HashSet<Pattern>(this.exclusions);
    }

    public void exclude(String ... regexes) {
        if (regexes != null) {
            for (String regex : regexes) {
                this.exclusions.add(Pattern.compile(regex));
            }
        }
    }

    public void clearExclusions() {
        this.exclusions.clear();
    }

    public void setUrlClassLoader(URLClassLoader urlClassLoader) {
        this.urlClassLoader = urlClassLoader;
    }

    public URLClassLoader getUrlClassLoader() {
        return this.urlClassLoader;
    }
}

