/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.TypeUtils;
import com.structurizr.model.Component;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FirstImplementationOfInterfaceSupportingTypesStrategy
extends SupportingTypesStrategy {
    private static final Log log = LogFactory.getLog(FirstImplementationOfInterfaceSupportingTypesStrategy.class);

    @Override
    public Set<Class<?>> findSupportingTypes(Component component) {
        HashSet set = new HashSet();
        try {
            Class type;
            Class<?> componentType = this.getTypeRepository().loadClass(component.getType().getType());
            if (componentType.isInterface() && (type = TypeUtils.findFirstImplementationOfInterface(componentType, this.getTypeRepository().getAllTypes())) != null) {
                set.add(type);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Could not load type " + component.getType().getType()));
        }
        return set;
    }
}

