/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ReferencedTypesSupportingTypesStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferencedTypesInSamePackageSupportingTypesStrategy
extends SupportingTypesStrategy {
    private boolean includeIndirectlyReferencedTypes;

    public ReferencedTypesInSamePackageSupportingTypesStrategy() {
        this(true);
    }

    public ReferencedTypesInSamePackageSupportingTypesStrategy(boolean includeIndirectlyReferencedTypes) {
        this.includeIndirectlyReferencedTypes = includeIndirectlyReferencedTypes;
    }

    @Override
    public Set<Class<?>> findSupportingTypes(Component component) {
        CodeElement codeElement = component.getType();
        if (codeElement != null) {
            ReferencedTypesSupportingTypesStrategy referencedTypesSupportingTypesStrategy = new ReferencedTypesSupportingTypesStrategy(this.includeIndirectlyReferencedTypes);
            referencedTypesSupportingTypesStrategy.setTypeRepository(this.getTypeRepository());
            Set<Class<?>> supportingTypes = referencedTypesSupportingTypesStrategy.findSupportingTypes(component);
            return supportingTypes.stream().filter(type -> type.getPackage().getName().startsWith(codeElement.getPackage())).collect(Collectors.toSet());
        }
        return new HashSet();
    }
}

