/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.AbstractWorkspace;
import com.structurizr.documentation.Documentation;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ViewSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Workspace
extends AbstractWorkspace {
    private static final Log log = LogFactory.getLog(Workspace.class);
    private Model model = new Model();
    private ViewSet viewSet = new ViewSet(this.model);
    private Documentation documentation = new Documentation(this.model);

    Workspace() {
    }

    public Workspace(String name, String description) {
        super(name, description);
    }

    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public ViewSet getViews() {
        return this.viewSet;
    }

    void setViews(ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public void hydrate() {
        this.viewSet.setModel(this.model);
        this.documentation.setModel(this.model);
        this.model.hydrate();
        this.viewSet.hydrate();
        this.documentation.hydrate();
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
        documentation.setModel(this.getModel());
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.model.isEmpty() && this.viewSet.isEmpty() && this.documentation.isEmpty();
    }

    public int countAndLogWarnings() {
        LinkedList<String> warnings = new LinkedList<String>();
        this.getModel().getElements().stream().filter(e -> !(e instanceof ContainerInstance)).filter(e -> e.getDescription() == null || e.getDescription().trim().length() == 0).forEach(e -> warnings.add("The " + this.typeof((Element)e) + " \"" + e.getCanonicalName().substring(1) + "\" is missing a description."));
        this.getModel().getElements().stream().filter(e -> e instanceof Container).map(e -> (Container)e).filter(c -> c.getTechnology() == null || c.getTechnology().trim().length() == 0).forEach(c -> warnings.add("The container \"" + c.getCanonicalName().substring(1) + "\" is missing a technology."));
        this.getModel().getElements().stream().filter(e -> e instanceof Component).map(e -> (Component)e).filter(c -> c.getTechnology() == null || c.getTechnology().trim().length() == 0).forEach(c -> warnings.add("The component \"" + c.getCanonicalName().substring(1) + "\" is missing a technology."));
        for (Relationship relationship : this.getModel().getRelationships()) {
            if (relationship.getSource() instanceof Component && relationship.getDestination() instanceof Component && relationship.getSource().getParent().equals(relationship.getDestination().getParent()) || relationship.getDescription() != null && relationship.getDescription().trim().length() != 0) continue;
            warnings.add("The relationship between " + this.typeof(relationship.getSource()) + " \"" + relationship.getSource().getCanonicalName().substring(1) + "\" and " + this.typeof(relationship.getDestination()) + " \"" + relationship.getDestination().getCanonicalName().substring(1) + "\" is missing a description.");
        }
        this.getViews().getEnterpriseContextViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Enterprise Context view \"" + v.getName() + "\": Missing key"));
        this.getViews().getSystemContextViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("System Context view \"" + v.getName() + "\": Missing key"));
        this.getViews().getContainerViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Container view \"" + v.getName() + "\": Missing key"));
        this.getViews().getComponentViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Component view \"" + v.getName() + "\": Missing key"));
        this.getViews().getDynamicViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Dynamic view \"" + v.getName() + "\": Missing key"));
        this.getViews().getDeploymentViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Deployment view \"" + v.getName() + "\": Missing key"));
        warnings.forEach(arg_0 -> ((Log)log).warn(arg_0));
        return warnings.size();
    }

    private String typeof(Element element) {
        if (element instanceof SoftwareSystem) {
            return "software system";
        }
        return element.getClass().getSimpleName().toLowerCase();
    }
}

