/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ComponentFinder;
import com.structurizr.analysis.ComponentFinderStrategy;
import com.structurizr.analysis.DefaultTypeRepository;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.TypeRepository;
import com.structurizr.analysis.TypeUtils;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractComponentFinderStrategy
implements ComponentFinderStrategy {
    private static final Log log = LogFactory.getLog(AbstractComponentFinderStrategy.class);
    private TypeRepository typeRepository;
    private Set<Component> componentsFound = new HashSet<Component>();
    protected ComponentFinder componentFinder;
    protected List<SupportingTypesStrategy> supportingTypesStrategies = new ArrayList<SupportingTypesStrategy>();

    protected AbstractComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        Arrays.stream(strategies).forEach(this::addSupportingTypesStrategy);
    }

    protected ComponentFinder getComponentFinder() {
        return this.componentFinder;
    }

    @Override
    public void setComponentFinder(ComponentFinder componentFinder) {
        this.componentFinder = componentFinder;
    }

    protected TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Override
    public void beforeFindComponents() throws Exception {
        this.typeRepository = new DefaultTypeRepository(this.componentFinder.getPackageName(), this.componentFinder.getExclusions());
        this.supportingTypesStrategies.forEach(sts -> sts.setTypeRepository(this.typeRepository));
    }

    @Override
    public Set<Component> findComponents() throws Exception {
        this.componentsFound.addAll(this.doFindComponents());
        return this.componentsFound;
    }

    protected abstract Set<Component> doFindComponents() throws Exception;

    @Override
    public void afterFindComponents() throws Exception {
        this.findSupportingTypes(this.componentsFound);
        this.findDependencies();
    }

    private void findSupportingTypes(Set<Component> components) throws Exception {
        for (Component component : components) {
            for (CodeElement codeElement : component.getCode()) {
                codeElement.setVisibility(TypeUtils.getVisibility(codeElement.getType()).getName());
                codeElement.setCategory(TypeUtils.getCategory(codeElement.getType()).getName());
            }
            for (SupportingTypesStrategy strategy : this.supportingTypesStrategies) {
                for (String type : strategy.findSupportingTypes(component)) {
                    if (this.componentFinder.getContainer().getComponentOfType(type) != null) continue;
                    CodeElement codeElement = component.addSupportingType(type);
                    codeElement.setVisibility(TypeUtils.getVisibility(type).getName());
                    codeElement.setCategory(TypeUtils.getCategory(type).getName());
                }
            }
        }
    }

    private void findDependencies() throws Exception {
        for (Component component : this.componentFinder.getContainer().getComponents()) {
            if (component.getType() == null) continue;
            this.addEfferentDependencies(component, component.getType(), new HashSet<String>());
            for (CodeElement codeElement : component.getCode()) {
                this.addEfferentDependencies(component, codeElement.getType(), new HashSet<String>());
            }
        }
    }

    private void addEfferentDependencies(Component component, String type, Set<String> typesVisited) throws Exception {
        typesVisited.add(type);
        for (Class<?> referencedType : this.getTypeRepository().findReferencedTypes(type)) {
            try {
                String referencedTypeName = referencedType.getCanonicalName();
                Component destinationComponent = this.componentFinder.getContainer().getComponentOfType(referencedTypeName);
                if (destinationComponent != null) {
                    if (component == destinationComponent) continue;
                    component.uses(destinationComponent, "");
                    continue;
                }
                if (typesVisited.contains(referencedTypeName)) continue;
                this.addEfferentDependencies(component, referencedTypeName, typesVisited);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
        }
    }

    public void addSupportingTypesStrategy(SupportingTypesStrategy supportingTypesStrategy) {
        if (supportingTypesStrategy == null) {
            throw new IllegalArgumentException("A supporting types strategy must be provided.");
        }
        this.supportingTypesStrategies.add(supportingTypesStrategy);
    }

    protected Set<Class<?>> findTypesAnnotatedWith(Class<? extends Annotation> annotation) throws Exception {
        return TypeUtils.findTypesAnnotatedWith(annotation, this.getTypeRepository().getAllTypes());
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology) throws Exception {
        return this.findClassesWithAnnotation(type, technology, false);
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology, boolean includePublicTypesOnly) throws Exception {
        HashSet<Component> components = new HashSet<Component>();
        Set<Class<?>> componentTypes = this.findTypesAnnotatedWith(type);
        for (Class<?> componentType : componentTypes) {
            if (includePublicTypesOnly && !Modifier.isPublic(componentType.getModifiers())) continue;
            components.add(this.getComponentFinder().getContainer().addComponent(componentType.getSimpleName(), componentType.getCanonicalName(), "", technology));
        }
        return components;
    }
}

