/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.google.common.base.Predicate;
import com.structurizr.analysis.TypeRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DefaultTypeRepository
implements TypeRepository {
    private static final Log log = LogFactory.getLog(DefaultTypeRepository.class);
    private final Set<Class<?>> types;
    private String packageToScan;
    private Set<Pattern> exclusions = new HashSet<Pattern>();
    private ClassPool classPool = ClassPool.getDefault();
    private Map<String, Set<Class<?>>> referencedTypesCache = new HashMap();

    public DefaultTypeRepository(String packageToScan, Set<Pattern> exclusions) {
        this.packageToScan = packageToScan;
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageToScan})).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        this.types = this.filter(reflections.getSubTypesOf(Object.class));
    }

    @Override
    public String getPackage() {
        return this.packageToScan;
    }

    @Override
    public Set<Class<?>> getAllTypes() {
        return new HashSet(this.types);
    }

    @Override
    public Set<Class<?>> findReferencedTypes(String typeName) throws Exception {
        HashSet referencedTypes = new HashSet();
        if (this.referencedTypesCache.containsKey(typeName)) {
            return this.referencedTypesCache.get(typeName);
        }
        try {
            CtClass cc = this.classPool.get(typeName);
            for (Object referencedType : cc.getRefClasses()) {
                String referencedTypeName = (String)referencedType;
                if (this.isExcluded(referencedTypeName)) continue;
                try {
                    referencedTypes.add(ClassLoader.getSystemClassLoader().loadClass(referencedTypeName));
                }
                catch (Throwable t) {
                    log.debug((Object)("Could not find " + referencedTypeName + " ... ignoring."));
                }
            }
            referencedTypes.remove(ClassLoader.getSystemClassLoader().loadClass(typeName));
        }
        catch (Exception e) {
            log.debug((Object)("Error finding referenced types for " + typeName + " ... ignoring."));
            this.referencedTypesCache.put(typeName, new HashSet());
        }
        this.referencedTypesCache.put(typeName, referencedTypes);
        return referencedTypes;
    }

    private Set<Class<?>> filter(Set<Class<?>> types) {
        return types.stream().filter((? super T c) -> !this.isExcluded(c.getCanonicalName())).collect(Collectors.toSet());
    }

    private boolean isExcluded(String typeName) {
        if (typeName == null) {
            return true;
        }
        for (Pattern exclude : this.exclusions) {
            if (!exclude.matcher(typeName).matches()) continue;
            return true;
        }
        return false;
    }
}

