/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.AbstractComponentFinderStrategy;
import com.structurizr.analysis.FirstImplementationOfInterfaceSupportingTypesStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.annotation.UsedByContainer;
import com.structurizr.annotation.UsedByPerson;
import com.structurizr.annotation.UsedBySoftwareSystem;
import com.structurizr.annotation.UsesComponent;
import com.structurizr.annotation.UsesContainer;
import com.structurizr.annotation.UsesSoftwareSystem;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StructurizrAnnotationsComponentFinderStrategy
extends AbstractComponentFinderStrategy {
    private static final Log log = LogFactory.getLog(StructurizrAnnotationsComponentFinderStrategy.class);

    public StructurizrAnnotationsComponentFinderStrategy() {
        super(new FirstImplementationOfInterfaceSupportingTypesStrategy());
    }

    public StructurizrAnnotationsComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        super(strategies);
    }

    @Override
    protected Set<Component> doFindComponents() throws Exception {
        HashSet<Component> components = new HashSet<Component>();
        Set<Class<?>> componentTypes = this.findTypesAnnotatedWith(com.structurizr.annotation.Component.class);
        for (Class<?> componentType : componentTypes) {
            Component component = this.getComponentFinder().getContainer().addComponent(componentType.getSimpleName(), componentType, componentType.getAnnotation(com.structurizr.annotation.Component.class).description(), componentType.getAnnotation(com.structurizr.annotation.Component.class).technology());
            components.add(component);
        }
        return components;
    }

    @Override
    public void afterFindComponents() throws Exception {
        super.afterFindComponents();
        for (Component component : this.getComponentFinder().getContainer().getComponents()) {
            if (component.getType() == null) continue;
            for (CodeElement codeElement : component.getCode()) {
                this.findUsesComponentAnnotations(component, codeElement.getType());
            }
            for (CodeElement codeElement : component.getCode()) {
                this.findUsesSoftwareSystemsAnnotations(component, codeElement.getType());
            }
            for (CodeElement codeElement : component.getCode()) {
                this.findUsesContainerAnnotations(component, codeElement.getType());
            }
            for (CodeElement codeElement : component.getCode()) {
                this.findUsedByPersonAnnotations(component, codeElement.getType());
            }
            for (CodeElement codeElement : component.getCode()) {
                this.findUsedBySoftwareSystemAnnotations(component, codeElement.getType());
            }
            for (CodeElement codeElement : component.getCode()) {
                this.findUsedByContainerAnnotations(component, codeElement.getType());
            }
        }
    }

    private void findUsesComponentAnnotations(Component component, String typeName) throws Exception {
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (Field field : type.getDeclaredFields()) {
            UsesComponent annotation = field.getAnnotation(UsesComponent.class);
            if (annotation == null) continue;
            String name = field.getType().getCanonicalName();
            String description = field.getAnnotation(UsesComponent.class).description();
            String technology = annotation.technology();
            Component destination = this.componentFinder.getContainer().getComponentOfType(name);
            if (destination != null) {
                for (Relationship relationship : component.getRelationships()) {
                    if (relationship.getDestination() != destination) continue;
                    relationship.setDescription(description);
                    relationship.setTechnology(technology);
                }
                continue;
            }
            log.warn((Object)("A component of type \"" + name + "\" could not be found."));
        }
    }

    private void findUsesSoftwareSystemsAnnotations(Component component, String typeName) throws Exception {
        UsesSoftwareSystem[] annotations;
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (UsesSoftwareSystem annotation : annotations = (UsesSoftwareSystem[])type.getAnnotationsByType(UsesSoftwareSystem.class)) {
            String name = annotation.name();
            String description = annotation.description();
            String technology = annotation.technology();
            SoftwareSystem softwareSystem = component.getModel().getSoftwareSystemWithName(name);
            if (softwareSystem != null) {
                component.uses(softwareSystem, description, technology);
                continue;
            }
            log.warn((Object)("A software system named \"" + name + "\" could not be found."));
        }
    }

    private void findUsesContainerAnnotations(Component component, String typeName) throws Exception {
        UsesContainer[] annotations;
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (UsesContainer annotation : annotations = (UsesContainer[])type.getAnnotationsByType(UsesContainer.class)) {
            String name = annotation.name();
            String description = annotation.description();
            String technology = annotation.technology();
            Container container = this.findContainerByNameOrCanonicalName(component, name);
            if (container != null) {
                component.uses(container, description, technology);
                continue;
            }
            log.warn((Object)("A container named \"" + name + "\" could not be found."));
        }
    }

    private void findUsedByPersonAnnotations(Component component, String typeName) throws Exception {
        UsedByPerson[] annotations;
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (UsedByPerson annotation : annotations = (UsedByPerson[])type.getAnnotationsByType(UsedByPerson.class)) {
            String name = annotation.name();
            String description = annotation.description();
            String technology = annotation.technology();
            Person person = component.getModel().getPersonWithName(name);
            if (person != null) {
                person.uses(component, description, technology);
                continue;
            }
            log.warn((Object)("A person named \"" + name + "\" could not be found."));
        }
    }

    private void findUsedBySoftwareSystemAnnotations(Component component, String typeName) throws Exception {
        UsedBySoftwareSystem[] annotations;
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (UsedBySoftwareSystem annotation : annotations = (UsedBySoftwareSystem[])type.getAnnotationsByType(UsedBySoftwareSystem.class)) {
            String name = annotation.name();
            String description = annotation.description();
            String technology = annotation.technology();
            SoftwareSystem softwareSystem = component.getModel().getSoftwareSystemWithName(name);
            if (softwareSystem != null) {
                softwareSystem.uses(component, description, technology);
                continue;
            }
            log.warn((Object)("A software system named \"" + name + "\" could not be found."));
        }
    }

    private void findUsedByContainerAnnotations(Component component, String typeName) throws Exception {
        UsedByContainer[] annotations;
        Class<?> type = ClassLoader.getSystemClassLoader().loadClass(typeName);
        for (UsedByContainer annotation : annotations = (UsedByContainer[])type.getAnnotationsByType(UsedByContainer.class)) {
            String name = annotation.name();
            String description = annotation.description();
            String technology = annotation.technology();
            Container container = this.findContainerByNameOrCanonicalName(component, name);
            if (container != null) {
                container.uses(component, description, technology);
                continue;
            }
            log.warn((Object)("A container named \"" + name + "\" could not be found."));
        }
    }

    private Container findContainerByNameOrCanonicalName(Component component, String name) {
        Element element;
        Container container = component.getContainer().getSoftwareSystem().getContainerWithName(name);
        if (container == null && (element = component.getModel().getElementWithCanonicalName(name)) != null && element instanceof Container) {
            container = (Container)element;
        }
        return container;
    }
}

