/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.api;

import com.structurizr.Workspace;
import com.structurizr.api.ApiError;
import com.structurizr.api.HashBasedMessageAuthenticationCode;
import com.structurizr.api.HmacAuthorizationHeader;
import com.structurizr.api.HmacContent;
import com.structurizr.api.Md5Digest;
import com.structurizr.api.StructurizrClientException;
import com.structurizr.encryption.EncryptedJsonReader;
import com.structurizr.encryption.EncryptedJsonWriter;
import com.structurizr.encryption.EncryptedWorkspace;
import com.structurizr.encryption.EncryptionLocation;
import com.structurizr.encryption.EncryptionStrategy;
import com.structurizr.io.json.JsonReader;
import com.structurizr.io.json.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class StructurizrClient {
    private static final Log log = LogFactory.getLog(StructurizrClient.class);
    private static final String STRUCTURIZR_API_URL = "structurizr.api.url";
    private static final String STRUCTURIZR_API_KEY = "structurizr.api.key";
    private static final String STRUCTURIZR_API_SECRET = "structurizr.api.secret";
    private static final String WORKSPACE_PATH = "/workspace/";
    private static final String VERSION = Package.getPackage("com.structurizr.api").getImplementationVersion();
    private String url;
    private String apiKey;
    private String apiSecret;
    private EncryptionStrategy encryptionStrategy;
    private boolean mergeFromRemote = true;
    private File workspaceArchiveLocation = new File(".");

    public StructurizrClient() throws StructurizrClientException {
        try {
            Properties properties = new Properties();
            InputStream in = StructurizrClient.class.getClassLoader().getResourceAsStream("structurizr.properties");
            if (in == null) {
                throw new StructurizrClientException("Could not find a structurizr.properties file on the classpath.");
            }
            properties.load(in);
            this.setUrl(properties.getProperty(STRUCTURIZR_API_URL));
            this.apiKey = properties.getProperty(STRUCTURIZR_API_KEY);
            this.apiSecret = properties.getProperty(STRUCTURIZR_API_SECRET);
            in.close();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public StructurizrClient(String apiKey, String apiSecret) {
        this("https://api.structurizr.com", apiKey, apiSecret);
    }

    public StructurizrClient(String url, String apiKey, String apiSecret) {
        this.setUrl(url);
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        if (url != null) {
            this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        }
    }

    public File getWorkspaceArchiveLocation() {
        return this.workspaceArchiveLocation;
    }

    public void setWorkspaceArchiveLocation(File workspaceArchiveLocation) {
        this.workspaceArchiveLocation = workspaceArchiveLocation;
    }

    public void setEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        this.encryptionStrategy = encryptionStrategy;
    }

    public void setMergeFromRemote(boolean mergeFromRemote) {
        this.mergeFromRemote = mergeFromRemote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Workspace getWorkspace(long workspaceId) throws StructurizrClientException {
        try {
            log.info((Object)("Getting workspace with ID " + workspaceId));
            CloseableHttpClient httpClient = HttpClients.createSystem();
            HttpGet httpGet = new HttpGet(this.url + WORKSPACE_PATH + workspaceId);
            this.addHeaders((HttpRequestBase)httpGet, "", "");
            this.debugRequest((HttpRequestBase)httpGet, null);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                this.debugResponse(response);
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.archiveWorkspace(workspaceId, json);
                    if (this.encryptionStrategy == null) {
                        Workspace workspace = new JsonReader().read(new StringReader(json));
                        return workspace;
                    }
                    EncryptedWorkspace encryptedWorkspace = new EncryptedJsonReader().read(new StringReader(json));
                    encryptedWorkspace.getEncryptionStrategy().setPassphrase(this.encryptionStrategy.getPassphrase());
                    Workspace workspace = encryptedWorkspace.getWorkspace();
                    return workspace;
                }
                ApiError apiError = ApiError.parse(json);
                throw new StructurizrClientException(apiError.getMessage());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public void putWorkspace(long workspaceId, Workspace workspace) throws StructurizrClientException {
        block20: {
            try {
                Workspace remoteWorkspace;
                if (workspace == null) {
                    throw new IllegalArgumentException("A workspace must be supplied");
                }
                if (workspaceId <= 0L) {
                    throw new IllegalArgumentException("The workspace ID must be set");
                }
                if (this.mergeFromRemote && (remoteWorkspace = this.getWorkspace(workspaceId)) != null) {
                    workspace.getViews().copyLayoutInformationFrom(remoteWorkspace.getViews());
                    workspace.getViews().getConfiguration().copyConfigurationFrom(remoteWorkspace.getViews().getConfiguration());
                }
                workspace.setId(workspaceId);
                workspace.countAndLogWarnings();
                CloseableHttpClient httpClient = HttpClients.createSystem();
                HttpPut httpPut = new HttpPut(this.url + WORKSPACE_PATH + workspaceId);
                StringWriter stringWriter = new StringWriter();
                if (this.encryptionStrategy == null) {
                    JsonWriter jsonWriter = new JsonWriter(false);
                    jsonWriter.write(workspace, stringWriter);
                } else {
                    EncryptedWorkspace encryptedWorkspace = new EncryptedWorkspace(workspace, this.encryptionStrategy);
                    this.encryptionStrategy.setLocation(EncryptionLocation.Client);
                    EncryptedJsonWriter jsonWriter = new EncryptedJsonWriter(false);
                    jsonWriter.write(encryptedWorkspace, stringWriter);
                }
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), ContentType.APPLICATION_JSON);
                httpPut.setEntity((HttpEntity)stringEntity);
                this.addHeaders((HttpRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity), ContentType.APPLICATION_JSON.toString());
                this.debugRequest((HttpRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity));
                log.info((Object)("Putting workspace with ID " + workspaceId));
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);){
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response.getStatusLine().getStatusCode() == 200) {
                        this.debugResponse(response);
                        log.info((Object)json);
                        break block20;
                    }
                    ApiError apiError = ApiError.parse(json);
                    throw new StructurizrClientException(apiError.getMessage());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new StructurizrClientException(e);
            }
        }
    }

    private void debugRequest(HttpRequestBase httpRequest, String content) {
        Header[] headers;
        log.debug((Object)(httpRequest.getMethod() + " " + httpRequest.getURI().getPath()));
        for (Header header : headers = httpRequest.getAllHeaders()) {
            log.debug((Object)(header.getName() + ": " + header.getValue()));
        }
        if (content != null) {
            log.debug((Object)content);
        }
    }

    private void debugResponse(CloseableHttpResponse response) {
        log.debug((Object)response.getStatusLine());
    }

    private void addHeaders(HttpRequestBase httpRequest, String content, String contentType) throws Exception {
        String httpMethod = httpRequest.getMethod();
        String path = httpRequest.getURI().getPath();
        String contentMd5 = new Md5Digest().generate(content);
        String nonce = "" + System.currentTimeMillis();
        HashBasedMessageAuthenticationCode hmac = new HashBasedMessageAuthenticationCode(this.apiSecret);
        HmacContent hmacContent = new HmacContent(httpMethod, path, contentMd5, contentType, nonce);
        httpRequest.addHeader("User-Agent", "structurizr-java/" + (VERSION != null ? VERSION : "dev"));
        httpRequest.addHeader("Authorization", new HmacAuthorizationHeader(this.apiKey, hmac.generate(hmacContent.toString())).format());
        httpRequest.addHeader("Nonce", nonce);
        if (httpMethod.equals("PUT")) {
            httpRequest.addHeader("Content-MD5", Base64.getEncoder().encodeToString(contentMd5.getBytes("UTF-8")));
            httpRequest.addHeader("Content-Type", contentType);
        }
    }

    private void archiveWorkspace(long workspaceId, String json) {
        if (this.workspaceArchiveLocation == null) {
            return;
        }
        File archiveFile = new File(this.workspaceArchiveLocation, this.createArchiveFileName(workspaceId));
        try {
            FileWriter fileWriter = new FileWriter(archiveFile);
            fileWriter.write(json);
            fileWriter.flush();
            fileWriter.close();
            try {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getCanonicalPath()));
            }
            catch (IOException ioe) {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not archive JSON to " + archiveFile.getAbsolutePath()));
        }
    }

    private String createArchiveFileName(long workspaceId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return "structurizr-" + workspaceId + "-" + sdf.format(new Date()) + ".json";
    }
}

