/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Image;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.TemplateMetadata;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import java.util.HashSet;
import java.util.Set;

public final class Documentation {
    private Model model;
    private Set<Section> sections = new HashSet<Section>();
    private Set<Image> images = new HashSet<Image>();
    private TemplateMetadata template;

    Documentation() {
    }

    public Documentation(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("A model must be specified.");
        }
        this.model = model;
    }

    @JsonIgnore
    Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    final Section addSection(Element element, String type, int group, Format format, String content) {
        if (group < 1) {
            group = 1;
        } else if (group > 5) {
            group = 5;
        }
        Section section = new Section(element, type, this.calculateOrder(), group, format, content);
        if (!this.sections.contains(section)) {
            this.sections.add(section);
            return section;
        }
        throw new IllegalArgumentException("A section of type " + type + (element != null ? " for " + element.getName() : "") + " already exists.");
    }

    private int calculateOrder() {
        return this.sections.size() + 1;
    }

    public Set<Section> getSections() {
        return new HashSet<Section>(this.sections);
    }

    void setSections(Set<Section> sections) {
        this.sections = sections;
    }

    void addImage(Image image) {
        this.images.add(image);
    }

    public Set<Image> getImages() {
        return new HashSet<Image>(this.images);
    }

    void setImages(Set<Image> images) {
        this.images = images;
    }

    public void hydrate() {
        for (Section section : this.sections) {
            if (section.getElementId() == null || section.getElementId().trim().length() <= 0) continue;
            section.setElement(this.model.getElement(section.getElementId()));
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.sections.isEmpty() && this.images.isEmpty();
    }

    public TemplateMetadata getTemplate() {
        return this.template;
    }

    void setTemplate(TemplateMetadata template) {
        this.template = template;
    }
}

