/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.AbstractWorkspace;
import com.structurizr.Workspace;
import com.structurizr.encryption.EncryptionStrategy;
import com.structurizr.io.json.JsonReader;
import com.structurizr.io.json.JsonWriter;
import java.io.StringReader;
import java.io.StringWriter;

public final class EncryptedWorkspace
extends AbstractWorkspace {
    private Workspace workspace;
    private String ciphertext;
    private String plaintext;
    private EncryptionStrategy encryptionStrategy;

    EncryptedWorkspace() {
    }

    public EncryptedWorkspace(Workspace workspace, EncryptionStrategy encryptionStrategy) throws Exception {
        JsonWriter jsonWriter = new JsonWriter(false);
        StringWriter stringWriter = new StringWriter();
        jsonWriter.write(workspace, stringWriter);
        this.init(workspace, stringWriter.toString(), encryptionStrategy);
    }

    public EncryptedWorkspace(Workspace workspace, String plaintext, EncryptionStrategy encryptionStrategy) throws Exception {
        this.init(workspace, plaintext, encryptionStrategy);
    }

    private void init(Workspace workspace, String plaintext, EncryptionStrategy encryptionStrategy) throws Exception {
        this.workspace = workspace;
        this.setId(workspace.getId());
        this.setName(workspace.getName());
        this.setDescription(workspace.getDescription());
        this.setVersion(workspace.getVersion());
        this.setThumbnail(workspace.getThumbnail());
        this.setApi(workspace.getApi());
        this.plaintext = plaintext;
        this.ciphertext = encryptionStrategy.encrypt(plaintext);
        this.encryptionStrategy = encryptionStrategy;
    }

    @JsonIgnore
    public Workspace getWorkspace() throws Exception {
        if (this.workspace != null) {
            return this.workspace;
        }
        if (this.ciphertext != null) {
            this.plaintext = this.encryptionStrategy.decrypt(this.ciphertext);
            JsonReader jsonReader = new JsonReader();
            StringReader stringReader = new StringReader(this.plaintext);
            return jsonReader.read(stringReader);
        }
        return null;
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public void setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
    }

    @JsonIgnore
    public String getPlaintext() throws Exception {
        if (this.plaintext != null) {
            return this.plaintext;
        }
        return this.encryptionStrategy.decrypt(this.ciphertext);
    }

    public EncryptionStrategy getEncryptionStrategy() {
        return this.encryptionStrategy;
    }

    public void setEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        this.encryptionStrategy = encryptionStrategy;
    }
}

