/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ContainerInstance
extends Element {
    private Container container;
    private String containerId;
    private int instanceId;

    ContainerInstance() {
    }

    ContainerInstance(Container container, int instanceId) {
        this.container = container;
        this.instanceId = instanceId;
    }

    @JsonIgnore
    public Container getContainer() {
        return this.container;
    }

    void setContainer(Container container) {
        this.container = container;
    }

    public String getContainerId() {
        if (this.container != null) {
            return this.container.getId();
        }
        return this.containerId;
    }

    void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Container Instance"));
    }

    @Override
    public String getTags() {
        return this.container.getTags() + "," + super.getTags();
    }

    @Override
    @JsonIgnore
    public String getCanonicalName() {
        return this.container.getCanonicalName() + "[" + this.instanceId + "]";
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.container.getParent();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    public Relationship uses(ContainerInstance destination, String description, String technology) {
        if (destination != null) {
            return this.getModel().addRelationship(this, destination, description, technology);
        }
        throw new IllegalArgumentException("The destination of a relationship must be specified.");
    }
}

