/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DeploymentNode
extends Element {
    private DeploymentNode parent;
    private String technology;
    private int instances = 1;
    private Set<DeploymentNode> children = new HashSet<DeploymentNode>();
    private Set<ContainerInstance> containerInstances = new HashSet<ContainerInstance>();

    public ContainerInstance add(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
        ContainerInstance containerInstance = this.getModel().addContainerInstance(container);
        this.containerInstances.add(containerInstance);
        return containerInstance;
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology) {
        return this.addDeploymentNode(name, description, technology, 1);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances) {
        return this.addDeploymentNode(name, description, technology, instances, null);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances, Map<String, String> properties) {
        DeploymentNode deploymentNode = this.getModel().addDeploymentNode(this, name, description, technology, instances, properties);
        if (deploymentNode != null) {
            this.children.add(deploymentNode);
        }
        return deploymentNode;
    }

    public DeploymentNode getDeploymentNodeWithName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        for (DeploymentNode deploymentNode : this.getChildren()) {
            if (!deploymentNode.getName().equals(name)) continue;
            return deploymentNode;
        }
        return null;
    }

    public Relationship uses(DeploymentNode destination, String description, String technology) {
        return this.getModel().addRelationship(this, destination, description, technology);
    }

    public Set<DeploymentNode> getChildren() {
        return new HashSet<DeploymentNode>(this.children);
    }

    public Set<ContainerInstance> getContainerInstances() {
        return new HashSet<ContainerInstance>(this.containerInstances);
    }

    void setChildren(Set<DeploymentNode> children) {
        this.children = children;
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.parent;
    }

    void setParent(DeploymentNode parent) {
        this.parent = parent;
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return new HashSet<String>();
    }

    @Override
    public String getTags() {
        return "";
    }

    @Override
    public String getCanonicalName() {
        if (this.getParent() != null) {
            return this.getParent().getCanonicalName() + "/" + this.formatForCanonicalName(this.getName());
        }
        return "/" + this.formatForCanonicalName(this.getName());
    }
}

