/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.structurizr.view.Color;
import com.structurizr.view.Routing;

public final class RelationshipStyle {
    private static final int START_OF_LINE = 0;
    private static final int END_OF_LINE = 100;
    private String tag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer thickness;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String color;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer fontSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer width;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean dashed;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Routing routing;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer position;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer opacity;

    RelationshipStyle() {
    }

    RelationshipStyle(String tag) {
        this.tag = tag;
    }

    public RelationshipStyle(String tag, Integer thickness, String color, Boolean dashed, Routing routing, Integer fontSize, Integer width, Integer position) {
        this.tag = tag;
        this.thickness = thickness;
        this.setColor(color);
        this.dashed = dashed;
        this.routing = routing;
        this.fontSize = fontSize;
        this.width = width;
        this.position = position;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getThickness() {
        return this.thickness;
    }

    public void setThickness(Integer thickness) {
        this.thickness = thickness;
    }

    public RelationshipStyle thickness(int thickness) {
        this.setThickness(thickness);
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        if (!Color.isHexColorCode(color)) {
            throw new IllegalArgumentException(color + " is not a valid hex colour code.");
        }
        this.color = color;
    }

    public RelationshipStyle color(String color) {
        this.setColor(color);
        return this;
    }

    public Boolean getDashed() {
        return this.dashed;
    }

    public void setDashed(Boolean dashed) {
        this.dashed = dashed;
    }

    public RelationshipStyle dashed(boolean dashed) {
        this.setDashed(dashed);
        return this;
    }

    public Routing getRouting() {
        return this.routing;
    }

    public void setRouting(Routing routing) {
        this.routing = routing;
    }

    public RelationshipStyle routing(Routing routing) {
        this.setRouting(routing);
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public RelationshipStyle fontSize(int fontSize) {
        this.setFontSize(fontSize);
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public RelationshipStyle width(int width) {
        this.setWidth(width);
        return this;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position == null ? null : (position < 0 ? Integer.valueOf(0) : (position > 100 ? Integer.valueOf(100) : position));
    }

    public RelationshipStyle position(int position) {
        this.setPosition(position);
        return this;
    }

    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        if (opacity != null) {
            this.opacity = opacity < 0 ? Integer.valueOf(0) : (opacity > 100 ? Integer.valueOf(100) : opacity);
        }
    }

    public RelationshipStyle opacity(int opacity) {
        this.setOpacity(opacity);
        return this;
    }
}

