/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.HashSet;
import java.util.Set;

public abstract class StaticView
extends View {
    StaticView() {
    }

    StaticView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
    }

    public void addAllSoftwareSystems() {
        this.getModel().getSoftwareSystems().forEach(this::add);
    }

    public void add(SoftwareSystem softwareSystem) {
        this.addElement(softwareSystem, true);
    }

    public void remove(SoftwareSystem softwareSystem) {
        this.removeElement(softwareSystem);
    }

    public void addAllPeople() {
        this.getModel().getPeople().forEach(this::add);
    }

    public void add(Person person) {
        this.addElement(person, true);
    }

    public void remove(Person person) {
        this.removeElement(person);
    }

    public abstract void addAllElements();

    public abstract void addNearestNeighbours(Element var1);

    protected <T extends Element> void addNearestNeighbours(Element element, Class<T> typeOfElement) {
        if (element == null) {
            return;
        }
        this.addElement(element, true);
        Set<Relationship> relationships = this.getModel().getRelationships();
        relationships.stream().filter(r -> r.getSource().equals(element) && typeOfElement.isInstance(r.getDestination())).map(Relationship::getDestination).forEach(d -> this.addElement((Element)d, true));
        relationships.stream().filter(r -> r.getDestination().equals(element) && typeOfElement.isInstance(r.getSource())).map(Relationship::getSource).forEach(s -> this.addElement((Element)s, true));
    }

    public void removeElementsThatCantBeReachedFrom(Element element) {
        if (element != null) {
            HashSet<Element> elementsToShow = new HashSet<Element>();
            HashSet<Element> elementsVisited = new HashSet<Element>();
            this.findElementsToShow(element, element, elementsToShow, elementsVisited);
            for (ElementView elementView : this.getElements()) {
                if (elementsToShow.contains(elementView.getElement())) continue;
                this.removeElement(elementView.getElement());
            }
        }
    }

    private void findElementsToShow(Element startingElement, Element element, Set<Element> elementsToShow, Set<Element> elementsVisited) {
        if (!elementsVisited.contains(element) && this.getElements().contains(new ElementView(element))) {
            elementsVisited.add(element);
            elementsToShow.add(element);
            if (!element.hasEfferentRelationshipWith(startingElement)) {
                element.getRelationships().forEach(r -> this.findElementsToShow(startingElement, r.getDestination(), elementsToShow, elementsVisited));
            }
        }
    }

    public final void removeElementsWithTag(String tag) {
        this.getElements().stream().map(ElementView::getElement).filter(e -> e.hasTag(tag)).forEach(this::removeElement);
    }

    public final void removeRelationshipsWithTag(String tag) {
        this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> r.hasTag(tag)).forEach(this::remove);
    }
}

