/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ElementView;
import com.structurizr.view.PaperSize;
import com.structurizr.view.RelationshipView;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class View {
    private SoftwareSystem softwareSystem;
    private String softwareSystemId;
    private String description = "";
    private String key;
    private PaperSize paperSize = PaperSize.A4_Portrait;
    private Set<ElementView> elementViews = new LinkedHashSet<ElementView>();
    private Set<RelationshipView> relationshipViews = new LinkedHashSet<RelationshipView>();

    View() {
    }

    View(SoftwareSystem softwareSystem, String key, String description) {
        this.softwareSystem = softwareSystem;
        if (key == null || key.trim().length() <= 0) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        this.setKey(key);
        this.setDescription(description);
    }

    @JsonIgnore
    public Model getModel() {
        return this.softwareSystem.getModel();
    }

    @JsonIgnore
    public SoftwareSystem getSoftwareSystem() {
        return this.softwareSystem;
    }

    public void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.softwareSystem = softwareSystem;
    }

    public String getSoftwareSystemId() {
        if (this.softwareSystem != null) {
            return this.softwareSystem.getId();
        }
        return this.softwareSystemId;
    }

    void setSoftwareSystemId(String softwareSystemId) {
        this.softwareSystemId = softwareSystemId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    @JsonIgnore
    public abstract String getName();

    protected final void addElement(Element element, boolean addRelationships) {
        if (element != null && this.getModel().contains(element)) {
            this.elementViews.add(new ElementView(element));
            if (addRelationships) {
                this.addRelationships(element);
            }
        }
    }

    private void addRelationships(Element element) {
        Set elements = this.getElements().stream().map(ElementView::getElement).collect(Collectors.toSet());
        for (Relationship relationship : element.getRelationships()) {
            if (!elements.contains(relationship.getDestination())) continue;
            this.relationshipViews.add(new RelationshipView(relationship));
        }
        for (Element e : elements) {
            for (Relationship r : e.getRelationships()) {
                if (!r.getDestination().equals(element)) continue;
                this.relationshipViews.add(new RelationshipView(r));
            }
        }
    }

    protected void removeElement(Element element) {
        if (element != null) {
            ElementView elementView = new ElementView(element);
            this.elementViews.remove(elementView);
            for (RelationshipView relationshipView : this.getRelationships()) {
                if (!relationshipView.getRelationship().getSource().equals(element) && !relationshipView.getRelationship().getDestination().equals(element)) continue;
                this.remove(relationshipView.getRelationship());
            }
        }
    }

    public RelationshipView add(Relationship relationship) {
        if (relationship != null && this.isElementInView(relationship.getSource()) && this.isElementInView(relationship.getDestination())) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.add(relationshipView);
            return relationshipView;
        }
        return null;
    }

    private boolean isElementInView(Element element) {
        return this.elementViews.stream().filter(ev -> ev.getElement().equals(element)).count() > 0L;
    }

    protected RelationshipView addRelationship(Relationship relationship, String description, String order) {
        RelationshipView relationshipView = this.add(relationship);
        if (relationshipView != null) {
            relationshipView.setDescription(description);
            relationshipView.setOrder(order);
        }
        return relationshipView;
    }

    public void remove(Relationship relationship) {
        if (relationship != null) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.remove(relationshipView);
        }
    }

    public void removeRelationshipsNotConnectedToElement(Element element) {
        if (element != null) {
            this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !r.getSource().equals(element) && !r.getDestination().equals(element)).forEach(this::remove);
        }
    }

    public Set<ElementView> getElements() {
        return new HashSet<ElementView>(this.elementViews);
    }

    void setElements(Set<ElementView> elementViews) {
        this.elementViews = elementViews;
    }

    public Set<RelationshipView> getRelationships() {
        return new HashSet<RelationshipView>(this.relationshipViews);
    }

    public void setRelationships(Set<RelationshipView> relationships) {
        this.relationshipViews = relationships;
    }

    public void removeElementsWithNoRelationships() {
        Set<RelationshipView> relationships = this.getRelationships();
        HashSet elementIds = new HashSet();
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getSourceId()));
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getDestinationId()));
        for (ElementView elementView : this.getElements()) {
            if (elementIds.contains(elementView.getId())) continue;
            this.removeElement(elementView.getElement());
        }
    }

    public void copyLayoutInformationFrom(View source) {
        this.setPaperSize(source.getPaperSize());
        for (ElementView sourceElementView : source.getElements()) {
            ElementView destinationElementView = this.findElementView(sourceElementView);
            if (destinationElementView == null) continue;
            destinationElementView.copyLayoutInformationFrom(sourceElementView);
        }
        for (RelationshipView sourceRelationshipView : source.getRelationships()) {
            RelationshipView destinationRelationshipView = this.findRelationshipView(sourceRelationshipView);
            if (destinationRelationshipView == null) continue;
            destinationRelationshipView.copyLayoutInformationFrom(sourceRelationshipView);
        }
    }

    private ElementView findElementView(ElementView sourceElementView) {
        for (ElementView elementView : this.getElements()) {
            if (!elementView.getElement().equals(sourceElementView.getElement())) continue;
            return elementView;
        }
        return null;
    }

    public ElementView getElementView(Element element) {
        Optional<ElementView> elementView = this.elementViews.stream().filter(ev -> ev.getElement().equals(element)).findFirst();
        return elementView.isPresent() ? elementView.get() : null;
    }

    protected RelationshipView findRelationshipView(RelationshipView sourceRelationshipView) {
        for (RelationshipView relationshipView : this.getRelationships()) {
            if (!relationshipView.getRelationship().equals(sourceRelationshipView.getRelationship())) continue;
            return relationshipView;
        }
        return null;
    }

    public RelationshipView getRelationshipView(Relationship relationship) {
        Optional<RelationshipView> relationshipView = this.relationshipViews.stream().filter(rv -> rv.getRelationship().equals(relationship)).findFirst();
        return relationshipView.isPresent() ? relationshipView.get() : null;
    }
}

