/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.Model;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.Configuration;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.EnterpriseContextView;
import com.structurizr.view.FilterMode;
import com.structurizr.view.FilteredView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.View;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ViewSet {
    private static final Log log = LogFactory.getLog(ViewSet.class);
    private Model model;
    private Collection<EnterpriseContextView> enterpriseContextViews = new HashSet<EnterpriseContextView>();
    private Collection<SystemContextView> systemContextViews = new HashSet<SystemContextView>();
    private Collection<ContainerView> containerViews = new HashSet<ContainerView>();
    private Collection<ComponentView> componentViews = new HashSet<ComponentView>();
    private Collection<DynamicView> dynamicViews = new HashSet<DynamicView>();
    private Collection<DeploymentView> deploymentViews = new HashSet<DeploymentView>();
    private Collection<FilteredView> filteredViews = new HashSet<FilteredView>();
    private Configuration configuration = new Configuration();

    ViewSet() {
    }

    public ViewSet(Model model) {
        this.model = model;
    }

    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public EnterpriseContextView createEnterpriseContextView(String key, String description) {
        this.assertThatTheViewKeyIsUnique(key);
        EnterpriseContextView view = new EnterpriseContextView(this.model, key, description);
        this.enterpriseContextViews.add(view);
        return view;
    }

    public SystemContextView createSystemContextView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsUnique(key);
        SystemContextView view = new SystemContextView(softwareSystem, key, description);
        this.systemContextViews.add(view);
        return view;
    }

    public ContainerView createContainerView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsUnique(key);
        ContainerView view = new ContainerView(softwareSystem, key, description);
        this.containerViews.add(view);
        return view;
    }

    public ComponentView createComponentView(Container container, String key, String description) {
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsUnique(key);
        ComponentView view = new ComponentView(container, key, description);
        this.componentViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(String key, String description) {
        this.assertThatTheViewKeyIsUnique(key);
        DynamicView view = new DynamicView(this.getModel(), key, description);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsUnique(key);
        DynamicView view = new DynamicView(softwareSystem, key, description);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(Container container, String key, String description) {
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsUnique(key);
        DynamicView view = new DynamicView(container, key, description);
        this.dynamicViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(String key, String description) {
        this.assertThatTheViewKeyIsUnique(key);
        DeploymentView view = new DeploymentView(this.getModel(), key, description);
        this.deploymentViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsUnique(key);
        DeploymentView view = new DeploymentView(softwareSystem, key, description);
        this.deploymentViews.add(view);
        return view;
    }

    public FilteredView createFilteredView(StaticView view, String key, String description, FilterMode mode, String ... tags) {
        this.assertThatTheViewKeyIsUnique(key);
        FilteredView filteredView = new FilteredView(view, key, description, mode, tags);
        this.filteredViews.add(filteredView);
        return filteredView;
    }

    private void assertThatTheViewKeyIsUnique(String key) {
        if (this.getViewWithKey(key) != null || this.getFilteredViewWithKey(key) != null) {
            throw new IllegalArgumentException("A view with the key " + key + " already exists.");
        }
    }

    private void assertThatTheSoftwareSystemIsNotNull(SoftwareSystem softwareSystem) {
        if (softwareSystem == null) {
            throw new IllegalArgumentException("Software system must not be null.");
        }
    }

    private void assertThatTheContainerIsNotNull(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Container must not be null.");
        }
    }

    public View getViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        HashSet<View> views = new HashSet<View>();
        views.addAll(this.systemContextViews);
        views.addAll(this.containerViews);
        views.addAll(this.componentViews);
        views.addAll(this.dynamicViews);
        views.addAll(this.deploymentViews);
        return views.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    public FilteredView getFilteredViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        return this.filteredViews.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    public Collection<EnterpriseContextView> getEnterpriseContextViews() {
        return new HashSet<EnterpriseContextView>(this.enterpriseContextViews);
    }

    public Collection<SystemContextView> getSystemContextViews() {
        return new HashSet<SystemContextView>(this.systemContextViews);
    }

    public Collection<ContainerView> getContainerViews() {
        return new HashSet<ContainerView>(this.containerViews);
    }

    public Collection<ComponentView> getComponentViews() {
        return new HashSet<ComponentView>(this.componentViews);
    }

    public Collection<DynamicView> getDynamicViews() {
        return new HashSet<DynamicView>(this.dynamicViews);
    }

    public Collection<FilteredView> getFilteredViews() {
        return new HashSet<FilteredView>(this.filteredViews);
    }

    public Collection<DeploymentView> getDeploymentViews() {
        return new HashSet<DeploymentView>(this.deploymentViews);
    }

    public void hydrate() {
        for (EnterpriseContextView enterpriseContextView : this.enterpriseContextViews) {
            enterpriseContextView.setModel(this.model);
            this.hydrateView(enterpriseContextView);
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            systemContextView.setSoftwareSystem(this.model.getSoftwareSystemWithId(systemContextView.getSoftwareSystemId()));
            this.hydrateView(systemContextView);
        }
        for (ContainerView containerView : this.containerViews) {
            containerView.setSoftwareSystem(this.model.getSoftwareSystemWithId(containerView.getSoftwareSystemId()));
            this.hydrateView(containerView);
        }
        for (ComponentView componentView : this.componentViews) {
            componentView.setSoftwareSystem(this.model.getSoftwareSystemWithId(componentView.getSoftwareSystemId()));
            componentView.setContainer(componentView.getSoftwareSystem().getContainerWithId(componentView.getContainerId()));
            this.hydrateView(componentView);
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            dynamicView.setModel(this.model);
            this.hydrateView(dynamicView);
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            deploymentView.setSoftwareSystem(this.model.getSoftwareSystemWithId(deploymentView.getSoftwareSystemId()));
            deploymentView.setModel(this.model);
            this.hydrateView(deploymentView);
        }
        for (FilteredView filteredView : this.filteredViews) {
            filteredView.setView(this.getViewWithKey(filteredView.getBaseViewKey()));
        }
    }

    private void hydrateView(View view) {
        for (ElementView elementView : view.getElements()) {
            elementView.setElement(this.model.getElement(elementView.getId()));
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            relationshipView.setRelationship(this.model.getRelationship(relationshipView.getId()));
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void copyLayoutInformationFrom(ViewSet source) {
        View sourceView;
        for (EnterpriseContextView enterpriseContextView : this.enterpriseContextViews) {
            sourceView = this.findView(source.getEnterpriseContextViews(), enterpriseContextView);
            if (sourceView != null) {
                enterpriseContextView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + enterpriseContextView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            sourceView = this.findView(source.getSystemContextViews(), systemContextView);
            if (sourceView != null) {
                systemContextView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + systemContextView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ContainerView containerView : this.containerViews) {
            sourceView = this.findView(source.getContainerViews(), containerView);
            if (sourceView != null) {
                containerView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + containerView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ComponentView componentView : this.componentViews) {
            sourceView = this.findView(source.getComponentViews(), componentView);
            if (sourceView != null) {
                componentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + componentView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            sourceView = this.findView(source.getDynamicViews(), dynamicView);
            if (sourceView != null) {
                dynamicView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + dynamicView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            sourceView = this.findView(source.getDeploymentViews(), deploymentView);
            if (sourceView != null) {
                deploymentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + deploymentView.getName() + "\" ... diagram layout information may be lost."));
        }
    }

    private <T extends View> T findView(Collection<T> views, T sourceView) {
        for (View view : views) {
            if (view.getKey() == null || !view.getKey().equals(sourceView.getKey())) continue;
            return (T)view;
        }
        for (View view : views) {
            if (!view.getName().equals(sourceView.getName())) continue;
            if (view.getDescription() != null) {
                if (!view.getDescription().equals(sourceView.getDescription())) continue;
                return (T)view;
            }
            return (T)view;
        }
        return null;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.enterpriseContextViews.isEmpty() && this.systemContextViews.isEmpty() && this.containerViews.isEmpty() && this.componentViews.isEmpty() && this.filteredViews.isEmpty();
    }
}

