/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.documentation.Decision;
import com.structurizr.documentation.DecisionStatus;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Image;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.TemplateMetadata;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public final class Documentation {
    private Model model;
    private Set<Section> sections = new HashSet<Section>();
    private Set<Decision> decisions = new HashSet<Decision>();
    private Set<Image> images = new HashSet<Image>();
    private TemplateMetadata template;

    Documentation() {
    }

    Documentation(@Nonnull Model model) {
        this.model = model;
    }

    @Nonnull
    final Section addSection(Element element, String title, Format format, String content) {
        if (element != null && !this.model.contains(element)) {
            throw new IllegalArgumentException("The element named " + element.getName() + " does not exist in the model associated with this documentation.");
        }
        this.checkTitleIsSpecified(title);
        this.checkContentIsSpecified(content);
        this.checkSectionIsUnique(element, title);
        this.checkFormatIsSpecified(format);
        Section section = new Section(element, title, this.calculateOrder(), format, content);
        this.sections.add(section);
        return section;
    }

    private void checkTitleIsSpecified(String title) {
        if (StringUtils.isNullOrEmpty(title)) {
            throw new IllegalArgumentException("A title must be specified.");
        }
    }

    private void checkContentIsSpecified(String content) {
        if (StringUtils.isNullOrEmpty(content)) {
            throw new IllegalArgumentException("Content must be specified.");
        }
    }

    private void checkFormatIsSpecified(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("A format must be specified.");
        }
    }

    private void checkSectionIsUnique(Element element, String title) {
        if (element == null) {
            for (Section section : this.sections) {
                if (section.getElement() != null || !title.equals(section.getTitle())) continue;
                throw new IllegalArgumentException("A section with a title of " + title + " already exists for this workspace.");
            }
        } else {
            for (Section section : this.sections) {
                if (!element.getId().equals(section.getElementId()) || !title.equals(section.getTitle())) continue;
                throw new IllegalArgumentException("A section with a title of " + title + " already exists for the element named " + element.getName() + ".");
            }
        }
    }

    private int calculateOrder() {
        return this.sections.size() + 1;
    }

    public Set<Section> getSections() {
        return new HashSet<Section>(this.sections);
    }

    void setSections(Set<Section> sections) {
        if (sections != null) {
            this.sections = new HashSet<Section>(sections);
        }
    }

    public Set<Decision> getDecisions() {
        return new HashSet<Decision>(this.decisions);
    }

    void setDecisions(Set<Decision> decisions) {
        if (decisions != null) {
            this.decisions = new HashSet<Decision>(decisions);
        }
    }

    public Decision addDecision(String id, Date date, String title, DecisionStatus status, Format format, String content) {
        return this.addDecision(null, id, date, title, status, format, content);
    }

    public Decision addDecision(SoftwareSystem softwareSystem, String id, Date date, String title, DecisionStatus status, Format format, String content) {
        this.checkIdIsSpecified(id);
        this.checkTitleIsSpecified(title);
        this.checkContentIsSpecified(content);
        this.checkDecisionStatusIsSpecified(status);
        this.checkFormatIsSpecified(format);
        this.checkDecisionIsUnique(softwareSystem, id);
        Decision decision = new Decision(softwareSystem, id, date, title, status, format, content);
        this.decisions.add(decision);
        return decision;
    }

    private void checkIdIsSpecified(String id) {
        if (StringUtils.isNullOrEmpty(id)) {
            throw new IllegalArgumentException("An ID must be specified.");
        }
    }

    private void checkDecisionStatusIsSpecified(DecisionStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("A status must be specified.");
        }
    }

    private void checkDecisionIsUnique(Element element, String id) {
        if (element == null) {
            for (Decision decision : this.decisions) {
                if (decision.getElement() != null || !id.equals(decision.getId())) continue;
                throw new IllegalArgumentException("A decision with an ID of " + id + " already exists for this workspace.");
            }
        } else {
            for (Decision decision : this.decisions) {
                if (!element.getId().equals(decision.getElementId()) || !id.equals(decision.getId())) continue;
                throw new IllegalArgumentException("A decision with an ID of " + id + " already exists for the element named " + element.getName() + ".");
            }
        }
    }

    void addImage(Image image) {
        this.images.add(image);
    }

    public Set<Image> getImages() {
        return new HashSet<Image>(this.images);
    }

    void setImages(Set<Image> images) {
        if (images != null) {
            this.images = new HashSet<Image>(images);
        }
    }

    void hydrate(Model model) {
        this.model = model;
        for (Section section : this.sections) {
            if (StringUtils.isNullOrEmpty(section.getElementId())) continue;
            section.setElement(model.getElement(section.getElementId()));
        }
        for (Decision decision : this.decisions) {
            if (StringUtils.isNullOrEmpty(decision.getElementId())) continue;
            decision.setElement(model.getElement(decision.getElementId()));
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.sections.isEmpty() && this.images.isEmpty() && this.decisions.isEmpty();
    }

    public TemplateMetadata getTemplate() {
        return this.template;
    }

    void setTemplate(TemplateMetadata template) {
        this.template = template;
    }
}

