/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.Element;
import com.structurizr.model.HttpHealthCheck;
import com.structurizr.util.Url;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ContainerInstance
extends DeploymentElement {
    private static final int DEFAULT_HEALTH_CHECK_INTERVAL_IN_SECONDS = 60;
    private static final long DEFAULT_HEALTH_CHECK_TIMEOUT_IN_MILLISECONDS = 0L;
    private Container container;
    private String containerId;
    private int instanceId;
    private Set<HttpHealthCheck> healthChecks = new HashSet<HttpHealthCheck>();

    ContainerInstance() {
    }

    ContainerInstance(Container container, int instanceId, String environment) {
        this.setContainer(container);
        this.addTags(new String[]{"Container Instance"});
        this.setInstanceId(instanceId);
        this.setEnvironment(environment);
    }

    @JsonIgnore
    public Container getContainer() {
        return this.container;
    }

    void setContainer(Container container) {
        this.container = container;
    }

    public String getContainerId() {
        if (this.container != null) {
            return this.container.getId();
        }
        return this.containerId;
    }

    void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return Collections.emptySet();
    }

    @Override
    public void removeTag(String tag) {
    }

    @Override
    @JsonIgnore
    public String getCanonicalName() {
        return this.container.getCanonicalName() + "[" + this.instanceId + "]";
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.container.getParent();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Nonnull
    public Set<HttpHealthCheck> getHealthChecks() {
        return new HashSet<HttpHealthCheck>(this.healthChecks);
    }

    void setHealthChecks(Set<HttpHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @Nonnull
    public HttpHealthCheck addHealthCheck(String name, String url) {
        return this.addHealthCheck(name, url, 60, 0L);
    }

    @Nonnull
    public HttpHealthCheck addHealthCheck(String name, String url, int interval, long timeout) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The name must not be null or empty.");
        }
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("The URL must not be null or empty.");
        }
        if (!Url.isUrl(url)) {
            throw new IllegalArgumentException(url + " is not a valid URL.");
        }
        if (interval < 0) {
            throw new IllegalArgumentException("The polling interval must be zero or a positive integer.");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout must be zero or a positive integer.");
        }
        HttpHealthCheck healthCheck = new HttpHealthCheck(name, url, interval, timeout);
        this.healthChecks.add(healthCheck);
        return healthCheck;
    }
}

