/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.StaticView;
import javax.annotation.Nonnull;

public final class ContainerView
extends StaticView {
    ContainerView() {
    }

    ContainerView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
    }

    @Override
    public void add(@Nonnull SoftwareSystem softwareSystem) {
        this.add(softwareSystem, true);
    }

    @Override
    public void add(@Nonnull SoftwareSystem softwareSystem, boolean addRelationships) {
        if (softwareSystem != null && !softwareSystem.equals(this.getSoftwareSystem())) {
            this.addElement(softwareSystem, addRelationships);
        }
    }

    public void addAllContainers() {
        this.getSoftwareSystem().getContainers().forEach(this::add);
    }

    public void add(Container container) {
        this.add(container, true);
    }

    public void add(Container container, boolean addRelationships) {
        this.addElement(container, addRelationships);
    }

    public void remove(Container container) {
        this.removeElement(container);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - Containers";
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
        this.addAllContainers();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, SoftwareSystem.class);
        super.addNearestNeighbours(element, Container.class);
    }

    public final void addAllInfluencers() {
        this.getModel().getSoftwareSystems().stream().filter(softwareSystem -> softwareSystem.hasEfferentRelationshipWith(this.getSoftwareSystem()) || this.getSoftwareSystem().hasEfferentRelationshipWith((Element)softwareSystem)).forEach(this::add);
        this.getModel().getPeople().stream().filter(person -> person.hasEfferentRelationshipWith(this.getSoftwareSystem()) || this.getSoftwareSystem().hasEfferentRelationshipWith((Element)person)).forEach(this::add);
        this.getRelationships().stream().map(view -> view.getRelationship()).filter(relationship -> !ContainerView.isPartOf(relationship.getDestination(), this.getSoftwareSystem()) && !ContainerView.isPartOf(relationship.getSource(), this.getSoftwareSystem())).forEach(this::remove);
    }

    public final void addAllContainersAndInfluencers() {
        this.addAllContainers();
        this.addAllInfluencers();
    }

    private static boolean isPartOf(Element element, Element other) {
        if (element.getId().equals(other.getId())) {
            return true;
        }
        if (element.getParent() != null) {
            return ContainerView.isPartOf(element.getParent(), other);
        }
        return false;
    }

    public final void addDependentSoftwareSystems() {
        this.getModel().getSoftwareSystems().stream().filter(softwareSystem -> softwareSystem.hasEfferentRelationshipWith(this.getSoftwareSystem())).forEach(this::add);
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }
}

