/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.Workspace;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.PaperSize;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlantUMLWriter {
    private int sizeLimit = 2000;
    private boolean includeNotesForActors = true;
    private final Map<String, String> skinParams = new LinkedHashMap<String, String>();
    private final List<String> includes = new ArrayList<String>();

    public PlantUMLWriter() {
        this.addSkinParam("shadowing", "false");
        this.addSkinParam("arrowColor", "#707070");
        this.addSkinParam("actorBorderColor", "#707070");
        this.addSkinParam("componentBorderColor", "#707070");
        this.addSkinParam("rectangleBorderColor", "#707070");
        this.addSkinParam("noteBackgroundColor", "#ffffff");
        this.addSkinParam("noteBorderColor", "#707070");
    }

    protected List<String> getIncludes() {
        return this.includes;
    }

    public void addIncludeFile(String file) {
        this.addIncludeFile(file, null);
    }

    public void addIncludeFile(String file, int id) {
        this.addIncludeFile(file, String.valueOf(id));
    }

    public void addIncludeFile(String file, String id) {
        if (id == null) {
            this.includes.add(String.format("!include %s", file));
        } else {
            this.includes.add(String.format("!include %s!%s", file, id));
        }
    }

    public void addIncludeURL(URI file) {
        this.addIncludeURL(file, null);
    }

    public void addIncludeURL(URI file, int id) {
        this.addIncludeURL(file, String.valueOf(id));
    }

    public void addIncludeURL(URI file, String id) {
        if (id == null) {
            this.includes.add(String.format("!includeurl %s", file));
        } else {
            this.includes.add(String.format("!includeurl %s!%s", file, id));
        }
    }

    public void clearIncludes() {
        this.includes.clear();
    }

    protected Map<String, String> getSkinParams() {
        return this.skinParams;
    }

    public void addSkinParam(String name, String value) {
        this.skinParams.put(name, value);
    }

    public void clearSkinParams() {
        this.skinParams.clear();
    }

    protected boolean isIncludeNotesForActors() {
        return this.includeNotesForActors;
    }

    public void setIncludeNotesForActors(boolean includeNotesForActors) {
        this.includeNotesForActors = includeNotesForActors;
    }

    protected int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public void write(Workspace workspace, Writer writer) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("A writer must be provided.");
        }
        workspace.getViews().getSystemLandscapeViews().forEach(v -> this.write((SystemLandscapeView)v, writer));
        workspace.getViews().getSystemContextViews().forEach(v -> this.write((SystemContextView)v, writer));
        workspace.getViews().getContainerViews().forEach(v -> this.write((ContainerView)v, writer));
        workspace.getViews().getComponentViews().forEach(v -> this.write((ComponentView)v, writer));
        workspace.getViews().getDynamicViews().forEach(v -> this.write((DynamicView)v, writer));
        workspace.getViews().getDeploymentViews().forEach(v -> this.write((DeploymentView)v, writer));
    }

    public void toStdOut(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        StringWriter stringWriter = new StringWriter();
        this.write(workspace, (Writer)stringWriter);
        System.out.println(stringWriter.toString());
    }

    public String[] toString(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        StringWriter stringWriter = new StringWriter();
        this.write(workspace, (Writer)stringWriter);
        String diagrams = stringWriter.toString();
        if (diagrams != null && diagrams.contains("@startuml")) {
            return stringWriter.toString().split("(?=@startuml)");
        }
        return new String[0];
    }

    public void write(View view, Writer writer) {
        if (view == null) {
            throw new IllegalArgumentException("A view must be provided.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("A writer must be provided.");
        }
        if (SystemLandscapeView.class.isAssignableFrom(view.getClass())) {
            this.write((SystemLandscapeView)view, writer);
        } else if (SystemContextView.class.isAssignableFrom(view.getClass())) {
            this.write((SystemContextView)view, writer);
        } else if (ContainerView.class.isAssignableFrom(view.getClass())) {
            this.write((ContainerView)view, writer);
        } else if (ComponentView.class.isAssignableFrom(view.getClass())) {
            this.write((ComponentView)view, writer);
        } else if (DynamicView.class.isAssignableFrom(view.getClass())) {
            this.write((DynamicView)view, writer);
        } else if (DeploymentView.class.isAssignableFrom(view.getClass())) {
            this.write((DeploymentView)view, writer);
        }
    }

    protected void write(SystemLandscapeView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() == Location.External).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.External).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            String name = view.getModel().getEnterprise() != null ? view.getModel().getEnterprise().getName() : "Enterprise";
            writer.write("package \"" + name + "\" {");
            writer.write(System.lineSeparator());
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() == Location.Internal).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, true));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.Internal).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(SystemContextView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(ContainerView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Container)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            writer.write("package \"" + view.getSoftwareSystem().getName() + "\" <<" + this.typeOf((Element)view.getSoftwareSystem()) + ">> {");
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Container).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(ComponentView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Component)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            writer.write("package \"" + view.getContainer().getName() + "\" <<" + this.typeOf((Element)view.getContainer()) + ">> {");
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Component).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(DynamicView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            view.getRelationships().stream().sorted((rv1, rv2) -> rv1.getOrder().compareTo(rv2.getOrder())).forEach(relationship -> {
                try {
                    writer.write(String.format("%s -[%s]> %s : %s. %s", this.idOf(relationship.getRelationship().getSource()), view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship.getRelationship()).getColor(), this.idOf(relationship.getRelationship().getDestination()), relationship.getOrder(), this.hasValue(relationship.getDescription()) ? relationship.getDescription() : (this.hasValue(relationship.getRelationship().getDescription()) ? relationship.getRelationship().getDescription() : "")));
                    writer.write(System.lineSeparator());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(DeploymentView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> ev.getElement() instanceof DeploymentNode && ev.getElement().getParent() == null).map(ev -> (DeploymentNode)ev.getElement()).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (DeploymentNode)e, writer, 0));
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void write(View view, DeploymentNode deploymentNode, Writer writer, int indent) {
        try {
            writer.write(String.format("%snode \"%s\" <<%s>> as %s {", this.calculateIndent(indent), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf((Element)deploymentNode), this.idOf((Element)deploymentNode)));
            writer.write(System.lineSeparator());
            for (DeploymentNode child : deploymentNode.getChildren()) {
                this.write(view, child, writer, indent + 1);
            }
            for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
                this.write(view, containerInstance, writer, indent + 1);
            }
            writer.write(String.format("%s}", this.calculateIndent(indent)));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void write(View view, ContainerInstance containerInstance, Writer writer, int indent) {
        try {
            writer.write(String.format("%s%s \"%s\" <<%s>> as %s %s", this.calculateIndent(indent), this.plantumlType(view, (Element)containerInstance.getContainer()), containerInstance.getContainer().getName(), this.typeOf((Element)containerInstance), this.idOf((Element)containerInstance), this.backgroundOf(view, (Element)containerInstance.getContainer())));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String calculateIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    protected void write(View view, Element element, Writer writer, boolean indent) {
        try {
            String type = this.plantumlType(view, element);
            List<String> description = this.lines(element.getDescription());
            if (description.isEmpty() || "actor".equals(type)) {
                this.writeSimpleElement(view, element, writer, indent, type);
                if (this.includeNotesForActors) {
                    this.writeDescriptionAsNote(element, writer, indent, description);
                }
            } else {
                String prefix = indent ? "  " : "";
                String separator = System.lineSeparator();
                String id = this.idOf(element);
                writer.write(String.format("%s%s %s <<%s>> %s [%s", prefix, type, id, this.typeOf(element), this.backgroundOf(view, element), separator));
                writer.write(String.format("%s  %s%s", prefix, element.getName(), separator));
                writer.write(String.format("%s  --%s", prefix, separator));
                for (String line : description) {
                    writer.write(String.format("%s  %s%s", prefix, line, separator));
                }
                writer.write(String.format("%s]%s", prefix, separator));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeSimpleElement(View view, Element element, Writer writer, boolean indent, String type) throws IOException {
        writer.write(String.format("%s%s \"%s\" <<%s>> as %s %s%s", indent ? "  " : "", type, element.getName(), this.typeOf(element), this.idOf(element), this.backgroundOf(view, element), System.lineSeparator()));
    }

    protected void writeDescriptionAsNote(Element element, Writer writer, boolean indent, List<String> description) throws IOException {
        if (!description.isEmpty()) {
            String prefix = indent ? "  " : "";
            String separator = System.lineSeparator();
            String id = this.idOf(element);
            writer.write(String.format("%snote right of %s%s", prefix, id, separator));
            for (String line : description) {
                writer.write(String.format("%s  %s%s", prefix, line, separator));
            }
            writer.write(String.format("%send note%s", prefix, separator));
        }
    }

    protected List<String> lines(String text) {
        if (text == null) {
            return Collections.emptyList();
        }
        String[] words = text.trim().split("\\s+");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() == 0) {
                line.append(word);
                continue;
            }
            if (line.length() + word.length() + 1 < 30) {
                line.append(' ').append(word);
                continue;
            }
            lines.add(line.toString());
            line.setLength(0);
            line.append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    protected String backgroundOf(View view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getBackground();
    }

    protected String plantumlType(View view, Element element) {
        Shape shape = view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getShape();
        switch (shape) {
            case Box: {
                return element instanceof Component ? "component" : "rectangle";
            }
            case Person: {
                return "actor";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "folder";
            }
            case Ellipse: 
            case Circle: {
                return "storage";
            }
        }
        return "rectangle";
    }

    protected void writeRelationships(View view, Writer writer) {
        view.getRelationships().stream().map(RelationshipView::getRelationship).sorted((r1, r2) -> (r1.getSource().getName() + r1.getDestination().getName()).compareTo(r2.getSource().getName() + r2.getDestination().getName())).forEach(r -> this.writeRelationship(view, (Relationship)r, writer));
    }

    protected void writeRelationship(View view, Relationship relationship, Writer writer) {
        try {
            String stereotypeAndDescription = (this.hasValue(relationship.getTechnology()) ? "<<" + relationship.getTechnology() + ">>\\n" : "") + (this.hasValue(relationship.getDescription()) ? relationship.getDescription() : "");
            writer.write(String.format("%s .[%s].> %s %s", this.idOf(relationship.getSource()), view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship).getColor(), this.idOf(relationship.getDestination()), this.hasValue(stereotypeAndDescription) ? ": " + stereotypeAndDescription : ""));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String idOf(Element e) {
        return e.getId();
    }

    protected String typeOf(Element e) {
        if (e instanceof SoftwareSystem) {
            return "Software System";
        }
        if (e instanceof Component) {
            Component component = (Component)e;
            return this.hasValue(component.getTechnology()) ? component.getTechnology() : "Component";
        }
        if (e instanceof DeploymentNode) {
            DeploymentNode deploymentNode = (DeploymentNode)e;
            return this.hasValue(deploymentNode.getTechnology()) ? deploymentNode.getTechnology() : "Deployment Node";
        }
        if (e instanceof ContainerInstance) {
            return "Container";
        }
        return e.getClass().getSimpleName();
    }

    protected boolean hasValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected void writeHeader(View view, Writer writer) throws IOException {
        int width;
        int height;
        writer.write(String.format("@startuml(id=%s)", view.getKey()));
        writer.write(System.lineSeparator());
        for (String include : this.includes) {
            writer.write(include);
            writer.write(System.lineSeparator());
        }
        PaperSize size = view.getPaperSize();
        if (size == null) {
            width = height = this.sizeLimit;
        } else {
            width = size.getWidth();
            height = size.getHeight();
            if (width > this.sizeLimit || height > this.sizeLimit) {
                int max = Math.max(width, height);
                width = width * this.sizeLimit / max;
                height = height * this.sizeLimit / max;
            }
        }
        writer.write("scale max ");
        writer.write(Integer.toString(width));
        writer.write("x");
        writer.write(Integer.toString(height));
        writer.write(System.lineSeparator());
        writer.write("title " + view.getName());
        writer.write(System.lineSeparator());
        if (view.getDescription() != null && view.getDescription().trim().length() > 0) {
            writer.write("caption " + view.getDescription());
            writer.write(System.lineSeparator());
        }
        writer.write(System.lineSeparator());
        if (!this.skinParams.isEmpty()) {
            writer.write(String.format("skinparam {%s", System.lineSeparator()));
            for (String name : this.skinParams.keySet()) {
                writer.write(String.format("  %s %s%s", name, this.skinParams.get(name), System.lineSeparator()));
            }
            writer.write(String.format("}%s", System.lineSeparator()));
        }
    }

    protected void writeFooter(Writer writer) throws IOException {
        writer.write("@enduml");
        writer.write(System.lineSeparator());
    }
}

