/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.AbstractSpringComponentFinderStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.Repository;

public final class SpringRepositoryComponentFinderStrategy
extends AbstractSpringComponentFinderStrategy {
    public SpringRepositoryComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        super(strategies);
    }

    protected Set<Component> doFindComponents() {
        HashSet<Component> components = new HashSet<Component>();
        components.addAll(this.findAnnotatedSpringRepositories());
        components.addAll(this.findSpringRepositoryInterfaces());
        return components;
    }

    private Set<Component> findSpringRepositoryInterfaces() {
        HashSet<Component> componentsFound = new HashSet<Component>();
        HashSet<Class> componentTypes = new HashSet<Class>();
        Set types = this.getTypeRepository().getAllTypes();
        for (Class type : types) {
            if (!type.isInterface() || !Repository.class.isAssignableFrom(type) && !JpaRepository.class.isAssignableFrom(type) && !CrudRepository.class.isAssignableFrom(type)) continue;
            componentTypes.add(type);
        }
        for (Class componentType : componentTypes) {
            Container container;
            if (this.includePublicTypesOnly && !Modifier.isPublic(componentType.getModifiers()) || (container = this.getComponentFinder().getContainer()).getComponentWithName(componentType.getSimpleName()) != null) continue;
            componentsFound.add(container.addComponent(componentType.getSimpleName(), componentType.getCanonicalName(), "", "Spring Repository"));
        }
        return componentsFound;
    }

    private Set<Component> findAnnotatedSpringRepositories() {
        return this.findInterfacesForImplementationClassesWithAnnotation(org.springframework.stereotype.Repository.class, "Spring Repository");
    }
}

