/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import com.taosdata.jdbc.ws.BlockResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.RequestFactory;
import com.taosdata.jdbc.ws.entity.Response;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class WSStatement
extends AbstractStatement {
    private final Transport transport;
    private String database;
    private final Connection connection;
    private final RequestFactory factory;
    private boolean closed;
    private ResultSet resultSet;

    public WSStatement(Transport transport, String database, Connection connection, RequestFactory factory) {
        this.transport = transport;
        this.database = database;
        this.connection = connection;
        this.factory = factory;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.affectedRows;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        Request request = this.factory.generateQuery(sql);
        CompletableFuture<Response> send = this.transport.send(request);
        try {
            Response response = send.get();
            QueryResp queryResp = (QueryResp)response;
            if (Code.SUCCESS.getCode() != queryResp.getCode()) {
                throw TSDBError.createSQLException(queryResp.getCode(), queryResp.getMessage());
            }
            if (SqlSyntaxValidator.isUseSql(sql)) {
                this.database = sql.trim().replace("use", "").trim();
                this.connection.setCatalog(this.database);
                this.connection.setClientInfo("dbname", this.database);
            }
            if (queryResp.isUpdate()) {
                this.resultSet = null;
                this.affectedRows = queryResp.getAffectedRows();
                return false;
            }
            this.resultSet = new BlockResultSet(this, this.transport, this.factory, queryResp, this.database);
            this.affectedRows = -1;
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw TSDBError.createSQLException(8967, e.getMessage());
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

