/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.mojo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import uk.co.codezen.maven.redlinerpm.mojo.RpmMojo;
import uk.co.codezen.maven.redlinerpm.rpm.DirectoryScannerFactory;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackage;
import uk.co.codezen.maven.redlinerpm.rpm.RpmScriptTemplateRenderer;
import uk.co.codezen.maven.redlinerpm.rpm.exception.InvalidPathException;

public abstract class AbstractRpmMojo
extends AbstractMojo
implements RpmMojo {
    protected Set<String> masterFiles = new HashSet<String>();
    protected RpmScriptTemplateRenderer templateRenderer = null;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project = null;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected String buildPath = null;
    @Parameter
    protected List<RpmPackage> packages = new ArrayList<RpmPackage>();
    @Parameter
    protected int defaultFileMode = 420;
    @Parameter
    protected String defaultOwner = "root";
    @Parameter
    protected String defaultGroup = "root";
    @Parameter
    protected String defaultDestination = File.separator;
    @Parameter
    protected List<String> excludes = new ArrayList<String>();
    @Parameter
    protected boolean performCheckingForExtraFiles = true;

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    @Override
    public RpmScriptTemplateRenderer getTemplateRenderer() {
        if (null == this.templateRenderer) {
            this.templateRenderer = new RpmScriptTemplateRenderer();
            this.templateRenderer.addParameter("project", this.getProject());
            this.templateRenderer.addParameter("env", System.getenv());
            Properties systemProperties = System.getProperties();
            for (String propertyName : systemProperties.stringPropertyNames()) {
                this.templateRenderer.addParameter(propertyName, systemProperties.getProperty(propertyName));
            }
            Properties projectProperties = this.getProject().getProperties();
            for (String propertyName : projectProperties.stringPropertyNames()) {
                this.templateRenderer.addParameter(propertyName, projectProperties.getProperty(propertyName));
            }
        }
        return this.templateRenderer;
    }

    @Override
    public String getProjectArtifactId() {
        return this.getProject().getArtifactId();
    }

    @Override
    public String getProjectVersion() {
        return this.getProject().getVersion();
    }

    @Override
    public String getProjectUrl() {
        return this.getProject().getUrl();
    }

    @Override
    public String getProjectPackagingType() {
        return this.getProject().getPackaging();
    }

    @Override
    public String getCollapsedProjectLicense() {
        String collapsedLicenseList = "";
        for (License license : this.getProject().getLicenses()) {
            if (collapsedLicenseList.equals("")) {
                collapsedLicenseList = license.getName();
                continue;
            }
            collapsedLicenseList = collapsedLicenseList + ", " + license.getName();
        }
        return collapsedLicenseList.length() > 0 ? collapsedLicenseList : null;
    }

    @Override
    public String getBuildDirectory() {
        return this.project.getBuild().getDirectory();
    }

    @Override
    public void setPrimaryArtifact(File artifactFile, String classifier) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler();
        handler.setExtension("rpm");
        DefaultArtifact artifact = new DefaultArtifact(this.getProject().getGroupId(), this.getProject().getArtifactId(), this.getProject().getVersion(), null, "rpm", classifier, (ArtifactHandler)handler);
        artifact.setFile(artifactFile);
        this.getProject().setArtifact((Artifact)artifact);
    }

    @Override
    public void addSecondaryArtifact(File artifactFile, String artifactId, String version, String classifier) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler();
        handler.setExtension("rpm");
        DefaultArtifact artifact = new DefaultArtifact(this.getProject().getGroupId(), artifactId, version, null, "rpm", classifier, (ArtifactHandler)handler);
        artifact.setFile(artifactFile);
        this.getProject().addAttachedArtifact((Artifact)artifact);
    }

    public void setBuildPath(String buildPath) {
        this.buildPath = buildPath;
    }

    @Override
    public String getBuildPath() throws InvalidPathException {
        try {
            return new File(this.buildPath).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new InvalidPathException(this.buildPath, ex);
        }
    }

    public void setPackages(List<RpmPackage> packages) {
        for (RpmPackage rpmPackage : packages) {
            rpmPackage.setMojo(this);
        }
        this.packages = packages;
    }

    public void setDefaultFileMode(int defaultFileMode) {
        this.defaultFileMode = defaultFileMode;
    }

    @Override
    public int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    public void setDefaultOwner(String defaultOwner) {
        this.defaultOwner = defaultOwner;
    }

    @Override
    public String getDefaultOwner() {
        return this.defaultOwner;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    @Override
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultDestination(String defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    @Override
    public String getDefaultDestination() {
        return this.defaultDestination;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setPerformCheckingForExtraFiles(boolean performCheckingForExtraFiles) {
        this.performCheckingForExtraFiles = performCheckingForExtraFiles;
    }

    public boolean isPerformCheckingForExtraFiles() {
        return this.performCheckingForExtraFiles;
    }

    protected void scanMasterFiles() {
        DirectoryScanner ds = DirectoryScannerFactory.factory(this.buildPath, null, this.excludes.toArray(new String[0]));
        ds.scan();
        String[] fileMatches = ds.getIncludedFiles();
        this.masterFiles = new HashSet<String>(fileMatches.length);
        Collections.addAll(this.masterFiles, fileMatches);
    }
}

