/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class CBORCanonical {
    static final Comparator<CBORObject> Comparer = new CtapComparer();

    private CBORCanonical() {
    }

    private static boolean IsArrayOrMap(CBORObject a) {
        return a.getType() == CBORType.Array || a.getType() == CBORType.Map;
    }

    public static byte[] CtapCanonicalEncode(CBORObject a) {
        return CBORCanonical.CtapCanonicalEncode(a, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static byte[] CtapCanonicalEncode(CBORObject a, int depth) {
        CBORType valueAType;
        CBORObject cbor;
        block27: {
            cbor = a.Untag();
            valueAType = cbor.getType();
            try {
                if (valueAType == CBORType.Array) {
                    ByteArrayOutputStream ms = null;
                    try {
                        ms = new ByteArrayOutputStream();
                        CBORObject.WriteValue((OutputStream)ms, 4, cbor.size());
                        for (int i = 0; i < cbor.size(); ++i) {
                            if (depth >= 3 && CBORCanonical.IsArrayOrMap(cbor.get(i))) {
                                throw new CBORException("Nesting level too deep");
                            }
                            byte[] bytes = CBORCanonical.CtapCanonicalEncode(cbor.get(i), depth + 1);
                            ms.write(bytes, 0, bytes.length);
                        }
                        byte[] i = ms.toByteArray();
                        return i;
                    }
                    finally {
                        try {
                            if (ms != null) {
                                ms.close();
                            }
                        }
                        catch (IOException bytes) {}
                    }
                }
                if (valueAType != CBORType.Map) break block27;
                ArrayList<CBORObject> sortedKeys = new ArrayList<CBORObject>();
                for (CBORObject key : cbor.getKeys()) {
                    if (depth >= 3 && (CBORCanonical.IsArrayOrMap(key) || CBORCanonical.IsArrayOrMap(cbor.get(key)))) {
                        throw new CBORException("Nesting level too deep");
                    }
                    sortedKeys.add(key);
                }
                Collections.sort(sortedKeys, Comparer);
                ByteArrayOutputStream ms = null;
                try {
                    ms = new ByteArrayOutputStream();
                    CBORObject.WriteValue((OutputStream)ms, 5, cbor.size());
                    for (CBORObject key : sortedKeys) {
                        byte[] bytes = CBORCanonical.CtapCanonicalEncode(key, depth + 1);
                        ms.write(bytes, 0, bytes.length);
                        bytes = CBORCanonical.CtapCanonicalEncode(cbor.get(key), depth + 1);
                        ms.write(bytes, 0, bytes.length);
                    }
                    Object object = ms.toByteArray();
                    return object;
                }
                finally {
                    try {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.toString(), ex);
            }
        }
        if (valueAType == CBORType.SimpleValue || valueAType == CBORType.Boolean || valueAType == CBORType.ByteString || valueAType == CBORType.TextString) {
            return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        }
        if (valueAType == CBORType.FloatingPoint) {
            long bits = cbor.AsDoubleBits();
            return new byte[]{-5, (byte)(bits >> 56 & 0xFFL), (byte)(bits >> 48 & 0xFFL), (byte)(bits >> 40 & 0xFFL), (byte)(bits >> 32 & 0xFFL), (byte)(bits >> 24 & 0xFFL), (byte)(bits >> 16 & 0xFFL), (byte)(bits >> 8 & 0xFFL), (byte)(bits & 0xFFL)};
        }
        if (valueAType == CBORType.Integer) {
            return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        }
        throw new IllegalArgumentException("Invalid CBOR type.");
    }

    private static final class CtapComparer
    implements Comparator<CBORObject> {
        private CtapComparer() {
        }

        @Override
        public int compare(CBORObject a, CBORObject b) {
            byte[] bbs;
            byte[] abs;
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            boolean bothBytes = false;
            if (a.getType() == CBORType.ByteString && b.getType() == CBORType.ByteString) {
                abs = a.GetByteString();
                bbs = b.GetByteString();
                bothBytes = true;
            } else {
                abs = CBORCanonical.CtapCanonicalEncode(a);
                bbs = CBORCanonical.CtapCanonicalEncode(b);
            }
            if (!bothBytes && (abs[0] & 0xE0) != (bbs[0] & 0xE0)) {
                return (abs[0] & 0xE0) < (bbs[0] & 0xE0) ? -1 : 1;
            }
            if (abs.length != bbs.length) {
                return abs.length < bbs.length ? -1 : 1;
            }
            for (int i = 0; i < abs.length; ++i) {
                if (abs[i] == bbs[i]) continue;
                int ai = abs[i] & 0xFF;
                int bi = bbs[i] & 0xFF;
                return ai < bi ? -1 : 1;
            }
            return 0;
        }
    }
}

