/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDouble;
import com.upokecenter.cbor.CBOREInteger;
import com.upokecenter.cbor.CBORExtendedDecimal;
import com.upokecenter.cbor.CBORExtendedFloat;
import com.upokecenter.cbor.CBORExtendedRational;
import com.upokecenter.cbor.CBORInteger;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

public final class CBORNumber
implements Comparable<CBORNumber> {
    private static final ICBORNumber[] NumberInterfaces = new ICBORNumber[]{new CBORInteger(), new CBORDouble(), new CBOREInteger(), new CBORExtendedDecimal(), new CBORExtendedFloat(), new CBORExtendedRational()};
    private final Kind kind;
    private final Object value;

    CBORNumber(Kind kind, Object value) {
        this.kind = kind;
        this.value = value;
    }

    ICBORNumber GetNumberInterface() {
        return CBORNumber.GetNumberInterface(this.kind);
    }

    static ICBORNumber GetNumberInterface(CBORObject obj) {
        CBORNumber num = CBORNumber.FromCBORObject(obj);
        return num == null ? null : num.GetNumberInterface();
    }

    Object GetValue() {
        return this.value;
    }

    static ICBORNumber GetNumberInterface(Kind kind) {
        switch (kind) {
            case Integer: {
                return NumberInterfaces[0];
            }
            case Double: {
                return NumberInterfaces[1];
            }
            case EInteger: {
                return NumberInterfaces[2];
            }
            case EDecimal: {
                return NumberInterfaces[3];
            }
            case EFloat: {
                return NumberInterfaces[4];
            }
            case ERational: {
                return NumberInterfaces[5];
            }
        }
        throw new IllegalStateException();
    }

    public CBORObject ToCBORObject() {
        return CBORObject.FromObject(this.value);
    }

    static boolean IsNumber(CBORObject o) {
        if (CBORNumber.IsUntaggedInteger(o)) {
            return true;
        }
        if (!o.isTagged() && o.getType() == CBORType.FloatingPoint) {
            return true;
        }
        if (o.HasOneTag(2) || o.HasOneTag(3)) {
            return o.getType() == CBORType.ByteString;
        }
        if (o.HasOneTag(4) || o.HasOneTag(5) || o.HasOneTag(264) || o.HasOneTag(265) || o.HasOneTag(268) || o.HasOneTag(269)) {
            return CBORNumber.CheckBigFracToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        if (o.HasOneTag(30) || o.HasOneTag(270)) {
            return CBORNumber.CheckRationalToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        return false;
    }

    public static CBORNumber FromCBORObject(CBORObject o) {
        if (o == null) {
            return null;
        }
        if (CBORNumber.IsUntaggedInteger(o)) {
            if (o.CanValueFitInInt64()) {
                return new CBORNumber(Kind.Integer, o.AsInt64Value());
            }
            return new CBORNumber(Kind.EInteger, o.AsEIntegerValue());
        }
        if (!o.isTagged() && o.getType() == CBORType.FloatingPoint) {
            return CBORNumber.FromObject(o.AsDoubleValue());
        }
        if (o.HasOneTag(2) || o.HasOneTag(3)) {
            return CBORNumber.BignumToNumber(o);
        }
        if (o.HasOneTag(4) || o.HasOneTag(5) || o.HasOneTag(264) || o.HasOneTag(265) || o.HasOneTag(268) || o.HasOneTag(269)) {
            return CBORNumber.BigFracToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        if (o.HasOneTag(30) || o.HasOneTag(270)) {
            return CBORNumber.RationalToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        return null;
    }

    private static boolean IsUntaggedInteger(CBORObject o) {
        return !o.isTagged() && o.getType() == CBORType.Integer;
    }

    private static boolean IsUntaggedIntegerOrBignum(CBORObject o) {
        return CBORNumber.IsUntaggedInteger(o) || (o.HasOneTag(2) || o.HasOneTag(3)) && o.getType() == CBORType.ByteString;
    }

    private static EInteger IntegerOrBignum(CBORObject o) {
        if (CBORNumber.IsUntaggedInteger(o)) {
            return o.AsEIntegerValue();
        }
        CBORNumber n = CBORNumber.BignumToNumber(o);
        return n.GetNumberInterface().AsEInteger(n.GetValue());
    }

    private static CBORNumber RationalToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return null;
        }
        if (tagName == 270) {
            if (o.size() != 3) {
                return null;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return null;
            }
        } else if (o.size() != 2) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return null;
        }
        EInteger numerator = CBORNumber.IntegerOrBignum(o.get(0));
        EInteger denominator = CBORNumber.IntegerOrBignum(o.get(1));
        if (denominator.signum() <= 0) {
            return null;
        }
        ERational erat = ERational.Create((EInteger)numerator, (EInteger)denominator);
        if (tagName == 270) {
            if (numerator.signum() < 0) {
                return null;
            }
            if (!o.get(2).CanValueFitInInt32()) {
                return null;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: {
                    break;
                }
                case 1: {
                    erat = erat.Negate();
                    break;
                }
                case 2: {
                    if (!numerator.isZero() || denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.PositiveInfinity;
                    break;
                }
                case 3: {
                    if (!numerator.isZero() || denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.NegativeInfinity;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.CreateNaN((EInteger)numerator, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return CBORNumber.FromObject(erat);
    }

    private static boolean CheckRationalToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return false;
        }
        if (tagName == 270) {
            if (o.size() != 3) {
                return false;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return false;
            }
        } else if (o.size() != 2) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return false;
        }
        EInteger denominator = CBORNumber.IntegerOrBignum(o.get(1));
        if (denominator.signum() <= 0) {
            return false;
        }
        if (tagName == 270) {
            EInteger numerator = CBORNumber.IntegerOrBignum(o.get(0));
            if (numerator.signum() < 0 || !o.get(2).CanValueFitInInt32()) {
                return false;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: {
                    return numerator.isZero() && denominator.compareTo(1) == 0;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return denominator.compareTo(1) == 0;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean CheckBigFracToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return false;
        }
        if (tagName == 268 || tagName == 269) {
            if (o.size() != 3) {
                return false;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return false;
            }
        } else if (o.size() != 2) {
            return false;
        }
        if (tagName == 4 || tagName == 5 ? !CBORNumber.IsUntaggedInteger(o.get(0)) : !CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return false;
        }
        if (tagName == 268 || tagName == 269) {
            EInteger exponent = CBORNumber.IntegerOrBignum(o.get(0));
            EInteger mantissa = CBORNumber.IntegerOrBignum(o.get(1));
            if (mantissa.signum() < 0 || !o.get(2).CanValueFitInInt32()) {
                return false;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: {
                    return exponent.isZero() && mantissa.isZero();
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return exponent.isZero();
                }
            }
            return false;
        }
        return true;
    }

    private static CBORNumber BigFracToNumber(CBORObject o, int tagName) {
        EFloat efloat;
        if (o.getType() != CBORType.Array) {
            return null;
        }
        if (tagName == 268 || tagName == 269) {
            if (o.size() != 3) {
                return null;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return null;
            }
        } else if (o.size() != 2) {
            return null;
        }
        if (tagName == 4 || tagName == 5 ? !CBORNumber.IsUntaggedInteger(o.get(0)) : !CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return null;
        }
        EInteger exponent = CBORNumber.IntegerOrBignum(o.get(0));
        EInteger mantissa = CBORNumber.IntegerOrBignum(o.get(1));
        boolean isdec = tagName == 4 || tagName == 264 || tagName == 268;
        EDecimal edec = isdec ? EDecimal.Create((EInteger)mantissa, (EInteger)exponent) : null;
        EFloat eFloat = efloat = !isdec ? EFloat.Create((EInteger)mantissa, (EInteger)exponent) : null;
        if (tagName == 268 || tagName == 269) {
            if (mantissa.signum() < 0) {
                return null;
            }
            if (!o.get(2).CanValueFitInInt32()) {
                return null;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: {
                    break;
                }
                case 1: {
                    if (isdec) {
                        edec = edec.Negate();
                        break;
                    }
                    efloat = efloat.Negate();
                    break;
                }
                case 2: {
                    if (!exponent.isZero() || !mantissa.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.PositiveInfinity;
                        break;
                    }
                    efloat = EFloat.PositiveInfinity;
                    break;
                }
                case 3: {
                    if (!exponent.isZero() || !mantissa.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.NegativeInfinity;
                        break;
                    }
                    efloat = EFloat.NegativeInfinity;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (!exponent.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.CreateNaN((EInteger)mantissa, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0, null);
                        break;
                    }
                    efloat = EFloat.CreateNaN((EInteger)mantissa, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0, null);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (isdec) {
            return CBORNumber.FromObject(edec);
        }
        return CBORNumber.FromObject(efloat);
    }

    private static CBORNumber BignumToNumber(CBORObject o) {
        EInteger bi;
        if (o.getType() != CBORType.ByteString) {
            return null;
        }
        boolean negative = o.HasMostInnerTag(3);
        byte[] data = o.GetByteString();
        if (data.length <= 7) {
            long x = 0L;
            for (int i = 0; i < data.length; ++i) {
                x <<= 8;
                x |= (long)data[i] & 0xFFL;
            }
            if (negative) {
                x = -x;
                --x;
            }
            return new CBORNumber(Kind.Integer, x);
        }
        int neededLength = data.length;
        boolean extended = false;
        if ((data[0] >> 7 & 1) != 0) {
            ++neededLength;
            extended = true;
        }
        byte[] bytes = new byte[neededLength];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = data[data.length - 1 - i];
            if (!negative) continue;
            bytes[i] = (byte)(~bytes[i] & 0xFF);
        }
        if (extended) {
            int n = bytes[bytes.length - 1] = negative ? -1 : 0;
        }
        if ((bi = EInteger.FromBytes((byte[])bytes, (boolean)true)).CanFitInInt64()) {
            return new CBORNumber(Kind.Integer, bi.ToInt64Checked());
        }
        return new CBORNumber(Kind.EInteger, bi);
    }

    public String toString() {
        switch (this.kind) {
            case Integer: {
                long longItem = (Long)this.value;
                return CBORUtilities.LongToString(longItem);
            }
        }
        return this.value == null ? "" : this.value.toString();
    }

    String ToJSONString() {
        switch (this.kind) {
            case Double: {
                double f = (Double)this.value;
                if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                    return "null";
                }
                String dblString = CBORUtilities.DoubleToString(f);
                return CBORUtilities.TrimDotZero(dblString);
            }
            case Integer: {
                long longItem = (Long)this.value;
                return CBORUtilities.LongToString(longItem);
            }
            case EInteger: {
                Object eiobj = this.value;
                return ((EInteger)eiobj).toString();
            }
            case EDecimal: {
                EDecimal dec = (EDecimal)this.value;
                if (dec.IsInfinity() || dec.IsNaN()) {
                    return "null";
                }
                return dec.toString();
            }
            case EFloat: {
                EFloat flo = (EFloat)this.value;
                if (flo.IsInfinity() || flo.IsNaN()) {
                    return "null";
                }
                if (flo.isFinite() && flo.getExponent().Abs().compareTo(EInteger.FromInt64((long)2500L)) > 0) {
                    double f = flo.ToDouble();
                    if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                        return "null";
                    }
                    String dblString = CBORUtilities.DoubleToString(f);
                    return CBORUtilities.TrimDotZero(dblString);
                }
                return flo.toString();
            }
            case ERational: {
                ERational dec = (ERational)this.value;
                EDecimal f = dec.ToEDecimalExactIfPossible(EContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    return "null";
                }
                return f.toString();
            }
        }
        throw new IllegalStateException();
    }

    static CBORNumber FromObject(int intValue) {
        return new CBORNumber(Kind.Integer, intValue);
    }

    static CBORNumber FromObject(long longValue) {
        return new CBORNumber(Kind.Integer, longValue);
    }

    static CBORNumber FromObject(double doubleValue) {
        return new CBORNumber(Kind.Double, doubleValue);
    }

    static CBORNumber FromObject(EInteger eivalue) {
        return new CBORNumber(Kind.EInteger, eivalue);
    }

    static CBORNumber FromObject(EFloat value) {
        return new CBORNumber(Kind.EFloat, value);
    }

    static CBORNumber FromObject(EDecimal value) {
        return new CBORNumber(Kind.EDecimal, value);
    }

    static CBORNumber FromObject(ERational value) {
        return new CBORNumber(Kind.ERational, value);
    }

    public CBORNumber Negate() {
        switch (this.kind) {
            case Integer: {
                if ((Long)this.value == 0L) {
                    return CBORNumber.FromObject(EDecimal.NegativeZero);
                }
                if ((Long)this.value == Long.MIN_VALUE) {
                    return CBORNumber.FromObject(EInteger.FromInt64((long)((Long)this.value)).Negate());
                }
                return new CBORNumber(this.kind, -((Long)this.value).longValue());
            }
            case EInteger: {
                if ((Long)this.value == 0L) {
                    return CBORNumber.FromObject(EDecimal.NegativeZero);
                }
                return CBORNumber.FromObject(((EInteger)this.value).Negate());
            }
        }
        return new CBORNumber(this.kind, this.GetNumberInterface().Negate(this.GetValue()));
    }

    public CBORNumber Add(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        Kind typeA = a.kind;
        Kind typeB = b.kind;
        if (typeA == Kind.Integer && typeB == Kind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueA < 0L && valueB < Long.MIN_VALUE - valueA || valueA > 0L && valueB > Long.MAX_VALUE - valueA) {
                return CBORNumber.FromObject(EInteger.FromInt64((long)valueA).Add(EInteger.FromInt64((long)valueB)));
            }
            return new CBORNumber(Kind.Integer, valueA + valueB);
        }
        if (typeA == Kind.ERational || typeB == Kind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return new CBORNumber(Kind.ERational, e1.Add(e2));
        }
        if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return new CBORNumber(Kind.EDecimal, e1.Add(e2));
        }
        if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return new CBORNumber(Kind.EFloat, e1.Add(e2));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(Kind.EInteger, b1.Add(b2));
    }

    public CBORNumber Subtract(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        Kind typeA = a.kind;
        Kind typeB = b.kind;
        if (typeA == Kind.Integer && typeB == Kind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB < 0L && Long.MAX_VALUE + valueB < valueA || valueB > 0L && Long.MIN_VALUE + valueB > valueA) {
                return CBORNumber.FromObject(EInteger.FromInt64((long)valueA).Subtract(EInteger.FromInt64((long)valueB)));
            }
            return new CBORNumber(Kind.Integer, valueA - valueB);
        }
        if (typeA == Kind.ERational || typeB == Kind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return new CBORNumber(Kind.ERational, e1.Subtract(e2));
        }
        if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return new CBORNumber(Kind.EDecimal, e1.Subtract(e2));
        }
        if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return new CBORNumber(Kind.EFloat, e1.Subtract(e2));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(Kind.EInteger, b1.Subtract(b2));
    }

    public CBORNumber Multiply(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        Kind typeA = a.kind;
        Kind typeB = b.kind;
        if (typeA == Kind.Integer && typeB == Kind.Integer) {
            boolean bpos;
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            boolean apos = valueA > 0L;
            boolean bl = bpos = valueB > 0L;
            if (apos && (!bpos && Long.MIN_VALUE / valueA > valueB || bpos && valueA > Long.MAX_VALUE / valueB) || !apos && (!bpos && valueA != 0L && Long.MAX_VALUE / valueA > valueB || bpos && valueA < Long.MIN_VALUE / valueB)) {
                EInteger bvalueA = EInteger.FromInt64((long)valueA);
                EInteger bvalueB = EInteger.FromInt64((long)valueB);
                return CBORNumber.FromObject(bvalueA.Multiply(bvalueB));
            }
            return CBORNumber.FromObject(valueA * valueB);
        }
        if (typeA == Kind.ERational || typeB == Kind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORNumber.FromObject(e1.Multiply(e2));
        }
        if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORNumber.FromObject(e1.Multiply(e2));
        }
        if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return new CBORNumber(Kind.EFloat, e1.Multiply(e2));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(Kind.EInteger, b1.Multiply(b2));
    }

    public CBORNumber Divide(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        Kind typeA = a.kind;
        Kind typeB = b.kind;
        if (typeA == Kind.Integer && typeB == Kind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB == 0L) {
                return valueA == 0L ? CBORNumber.FromObject(EDecimal.NaN) : (valueA < 0L ? CBORNumber.FromObject(EDecimal.NegativeInfinity) : CBORNumber.FromObject(EDecimal.PositiveInfinity));
            }
            if (valueA == Long.MIN_VALUE && valueB == -1L) {
                return new CBORNumber(Kind.Integer, valueA).Negate();
            }
            long quo = valueA / valueB;
            long rem = valueA - quo * valueB;
            return rem == 0L ? new CBORNumber(Kind.Integer, quo) : new CBORNumber(Kind.ERational, ERational.Create((EInteger)EInteger.FromInt64((long)valueA), (EInteger)EInteger.FromInt64((long)valueB)));
        }
        if (typeA == Kind.ERational || typeB == Kind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return new CBORNumber(Kind.ERational, e1.Divide(e2));
        }
        if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            if (e1.isZero() && e2.isZero()) {
                return new CBORNumber(Kind.EDecimal, EDecimal.NaN);
            }
            EDecimal eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return new CBORNumber(Kind.EDecimal, eret);
            }
            ERational er1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational er2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return new CBORNumber(Kind.ERational, er1.Divide(er2));
        }
        if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
            if (e1.isZero() && e2.isZero()) {
                return CBORNumber.FromObject(EDecimal.NaN);
            }
            EFloat eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return CBORNumber.FromObject(eret);
            }
            ERational er1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational er2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return new CBORNumber(Kind.ERational, er1.Divide(er2));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        if (b2.isZero()) {
            return b1.isZero() ? CBORNumber.FromObject(EDecimal.NaN) : (b1.signum() < 0 ? CBORNumber.FromObject(EDecimal.NegativeInfinity) : CBORNumber.FromObject(EDecimal.PositiveInfinity));
        }
        EInteger[] divrem = b1.DivRem(b2);
        EInteger bigquo = divrem[0];
        EInteger bigrem = divrem[1];
        return bigrem.isZero() ? CBORNumber.FromObject(bigquo) : new CBORNumber(Kind.ERational, ERational.Create((EInteger)b1, (EInteger)b2));
    }

    public CBORNumber Remainder(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        Object objA = this.value;
        Object objB = b.value;
        Kind typeA = this.kind;
        Kind typeB = b.kind;
        if (typeA == Kind.Integer && typeB == Kind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            return valueA == Long.MIN_VALUE && valueB == -1L ? CBORNumber.FromObject(0) : CBORNumber.FromObject(valueA % valueB);
        }
        if (typeA == Kind.ERational || typeB == Kind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORNumber.FromObject(e1.Remainder(e2));
        }
        if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORNumber.FromObject(e1.Remainder(e2, null));
        }
        if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return CBORNumber.FromObject(e1.Remainder(e2, null));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return CBORNumber.FromObject(b1.Remainder(b2));
    }

    @Override
    public int compareTo(CBORNumber other) {
        int cmp;
        block32: {
            int s2;
            Object objB;
            Object objA;
            Kind typeB;
            Kind typeA;
            block31: {
                if (other == null) {
                    return 1;
                }
                if (this == other) {
                    return 0;
                }
                cmp = 0;
                typeA = this.kind;
                typeB = other.kind;
                objA = this.value;
                objB = other.value;
                if (typeA != typeB) break block31;
                switch (typeA) {
                    case Integer: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = a == b ? 0 : (a < b ? -1 : 1);
                        break block32;
                    }
                    case EInteger: {
                        EInteger bigintA = (EInteger)objA;
                        EInteger bigintB = (EInteger)objB;
                        cmp = bigintA.compareTo(bigintB);
                        break block32;
                    }
                    case Double: {
                        double a = (Double)objA;
                        double b = (Double)objB;
                        cmp = Double.isNaN(a) ? (Double.isNaN(b) ? 0 : 1) : (Double.isNaN(b) ? -1 : (a == b ? 0 : (a < b ? -1 : 1)));
                        break block32;
                    }
                    case EDecimal: {
                        cmp = ((EDecimal)objA).compareTo((EDecimal)objB);
                        break block32;
                    }
                    case EFloat: {
                        cmp = ((EFloat)objA).compareTo((EFloat)objB);
                        break block32;
                    }
                    case ERational: {
                        cmp = ((ERational)objA).compareTo((ERational)objB);
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected data type");
                    }
                }
            }
            int s1 = CBORNumber.GetNumberInterface(typeA).Sign(objA);
            if (s1 != (s2 = CBORNumber.GetNumberInterface(typeB).Sign(objB)) && s1 != 2 && s2 != 2) {
                return s1 < s2 ? -1 : 1;
            }
            if (s1 == 2 && s2 == 2) {
                cmp = 0;
            } else {
                if (s1 == 2) {
                    return 1;
                }
                if (s2 == 2) {
                    return -1;
                }
                if (typeA == Kind.ERational) {
                    ERational e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedRational(objA);
                    if (typeB == Kind.EDecimal) {
                        EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
                        cmp = e1.CompareToDecimal(e2);
                    } else {
                        EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
                        cmp = e1.CompareToBinary(e2);
                    }
                } else if (typeB == Kind.ERational) {
                    ERational e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedRational(objB);
                    if (typeA == Kind.EDecimal) {
                        EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
                        cmp = e2.CompareToDecimal(e1);
                        cmp = -cmp;
                    } else {
                        EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
                        cmp = e2.CompareToBinary(e1);
                        cmp = -cmp;
                    }
                } else if (typeA == Kind.EDecimal || typeB == Kind.EDecimal) {
                    EDecimal e1 = null;
                    EDecimal e2 = null;
                    if (typeA == Kind.EFloat) {
                        EFloat ef1 = (EFloat)objA;
                        e2 = (EDecimal)objB;
                        cmp = e2.CompareToBinary(ef1);
                        cmp = -cmp;
                    } else if (typeB == Kind.EFloat) {
                        EFloat ef1 = (EFloat)objB;
                        e2 = (EDecimal)objA;
                        cmp = e2.CompareToBinary(ef1);
                    } else {
                        e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedDecimal(objA);
                        e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedDecimal(objB);
                        cmp = e1.compareTo(e2);
                    }
                } else if (typeA == Kind.EFloat || typeB == Kind.EFloat || typeA == Kind.Double || typeB == Kind.Double) {
                    EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsExtendedFloat(objA);
                    EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsExtendedFloat(objB);
                    cmp = e1.compareTo(e2);
                } else {
                    EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
                    EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
                    cmp = b1.compareTo(b2);
                }
            }
        }
        return cmp;
    }

    static enum Kind {
        Integer,
        Double,
        EInteger,
        EDecimal,
        EFloat,
        ERational;

    }
}

