/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORNumber;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import java.util.Date;

public final class CBORDateConverter
implements ICBORToFromConverter<Date> {
    public static final CBORDateConverter TaggedString = new CBORDateConverter(ConversionType.TaggedString);
    public static final CBORDateConverter TaggedNumber = new CBORDateConverter(ConversionType.TaggedNumber);
    public static final CBORDateConverter UntaggedNumber = new CBORDateConverter(ConversionType.UntaggedNumber);
    private final ConversionType propVartype;

    public CBORDateConverter() {
        this(ConversionType.TaggedString);
    }

    public final ConversionType getType() {
        return this.propVartype;
    }

    public CBORDateConverter(ConversionType convType) {
        this.propVartype = convType;
    }

    @Override
    public Date FromCBORObject(CBORObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        EInteger[] outYear = new EInteger[1];
        int[] lesserFields = new int[7];
        String str = this.TryGetDateTimeFieldsInternal(obj, outYear, lesserFields);
        if (str != null) {
            throw new CBORException(str);
        }
        return PropertyMap.BuildUpDateTime(outYear[0], lesserFields);
    }

    public boolean TryGetDateTimeFields(CBORObject obj, EInteger[] year, int[] lesserFields) {
        if (year == null) {
            return false;
        }
        EInteger[] outYear = year;
        if (outYear.length < 1) {
            return false;
        }
        if (lesserFields == null) {
            return false;
        }
        if (lesserFields.length < 7) {
            return false;
        }
        String str = this.TryGetDateTimeFieldsInternal(obj, outYear, lesserFields);
        if (str == null) {
            return true;
        }
        outYear[0] = null;
        for (int i = 0; i < 7; ++i) {
            lesserFields[i] = 0;
        }
        return false;
    }

    private String TryGetDateTimeFieldsInternal(CBORObject obj, EInteger[] year, int[] lesserFields) {
        if (obj == null) {
            return "Object is null";
        }
        if (year == null) {
            return "Year is null";
        }
        EInteger[] outYear = year;
        if (outYear.length < 1) {
            return "\"year\" + \"'s length\" (" + outYear.length + ") is not greater or equal to 1";
        }
        if (lesserFields == null) {
            return "Lesser fields is null";
        }
        if (lesserFields.length < 7) {
            return "\"lesserFields\" + \"'s length\" (" + lesserFields.length + ") is not greater or equal to 7";
        }
        ConversionType thisType = this.getType();
        if (thisType == ConversionType.UntaggedNumber) {
            if (obj.isTagged()) {
                return "May not be tagged";
            }
            CBORObject untagobj = obj;
            if (!untagobj.isNumber()) {
                return "Not a finite number";
            }
            CBORNumber num = untagobj.AsNumber();
            if (!num.IsFinite()) {
                return "Not a finite number";
            }
            if (num.compareTo(Long.MIN_VALUE) < 0 || num.compareTo(Long.MAX_VALUE) > 0) {
                return "Too big or small to fit a java.util.Date";
            }
            if (num.CanFitInInt64()) {
                CBORUtilities.BreakDownSecondsSinceEpoch(num.ToInt64Checked(), outYear, lesserFields);
            } else {
                EDecimal dec = untagobj.ToEDecimal();
                CBORUtilities.BreakDownSecondsSinceEpoch(dec, outYear, lesserFields);
            }
            return null;
        }
        if (obj.HasMostOuterTag(0)) {
            String str = obj.AsString();
            try {
                CBORUtilities.ParseAtomDateTimeString(str, outYear, lesserFields);
                return null;
            }
            catch (ArithmeticException ex) {
                return ex.getMessage();
            }
            catch (IllegalStateException ex) {
                return ex.getMessage();
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
        }
        if (obj.HasMostOuterTag(1)) {
            CBORObject untagobj = obj.UntagOne();
            if (!untagobj.isNumber()) {
                return "Not a finite number";
            }
            CBORNumber num = untagobj.AsNumber();
            if (!num.IsFinite()) {
                return "Not a finite number";
            }
            if (num.CanFitInInt64()) {
                CBORUtilities.BreakDownSecondsSinceEpoch(num.ToInt64Checked(), outYear, lesserFields);
            } else {
                EDecimal dec = untagobj.ToEDecimal();
                CBORUtilities.BreakDownSecondsSinceEpoch(dec, outYear, lesserFields);
            }
            return null;
        }
        return "Not tag 0 or 1";
    }

    public CBORObject DateTimeFieldsToCBORObject(int smallYear, int month, int day) {
        return this.DateTimeFieldsToCBORObject(EInteger.FromInt32((int)smallYear), new int[]{month, day, 0, 0, 0, 0, 0});
    }

    public CBORObject DateTimeFieldsToCBORObject(int smallYear, int month, int day, int hour, int minute, int second) {
        return this.DateTimeFieldsToCBORObject(EInteger.FromInt32((int)smallYear), new int[]{month, day, hour, minute, second, 0, 0});
    }

    public CBORObject DateTimeFieldsToCBORObject(int year, int[] lesserFields) {
        return this.DateTimeFieldsToCBORObject(EInteger.FromInt32((int)year), lesserFields);
    }

    public CBORObject DateTimeFieldsToCBORObject(EInteger bigYear, int[] lesserFields) {
        if (bigYear == null) {
            throw new NullPointerException("bigYear");
        }
        if (lesserFields == null) {
            throw new NullPointerException("lesserFields");
        }
        if (lesserFields.length < 7) {
            throw new IllegalArgumentException("\"lesserFields\" + \"'s length\" (" + lesserFields.length + ") is not greater or equal to 7");
        }
        try {
            CBORUtilities.CheckYearAndLesserFields(bigYear, lesserFields);
            ConversionType thisType = this.getType();
            switch (thisType.ordinal()) {
                case 0: {
                    String str = CBORUtilities.ToAtomDateTimeString(bigYear, lesserFields);
                    return CBORObject.FromString(str).WithTag(0);
                }
                case 1: 
                case 2: {
                    try {
                        int[] status = new int[1];
                        EFloat ef = CBORUtilities.DateTimeToIntegerOrDouble(bigYear, lesserFields, status);
                        switch (status[0]) {
                            case 0: {
                                CBORObject cbor = CBORObject.FromEInteger(ef.ToEInteger());
                                return thisType == ConversionType.TaggedNumber ? CBORObject.FromCBORObjectAndTag(cbor, 1) : cbor;
                            }
                            case 1: {
                                return thisType == ConversionType.TaggedNumber ? CBORObject.FromFloatingPointBits(ef.ToDoubleBits(), 8).WithTag(1) : CBORObject.FromFloatingPointBits(ef.ToDoubleBits(), 8);
                            }
                        }
                        throw new CBORException("Too big or small to fit an integer or floating-point number");
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CBORException(ex.getMessage(), ex);
                    }
                }
            }
            throw new CBORException("Internal error");
        }
        catch (IllegalArgumentException ex) {
            throw new CBORException(ex.getMessage(), ex);
        }
    }

    @Override
    public CBORObject ToCBORObject(Date obj) {
        try {
            int[] lesserFields = new int[7];
            EInteger[] outYear = new EInteger[1];
            PropertyMap.BreakDownDateTime(obj, outYear, lesserFields);
            return this.DateTimeFieldsToCBORObject(outYear[0], lesserFields);
        }
        catch (IllegalArgumentException ex) {
            throw new CBORException(ex.getMessage(), ex);
        }
    }

    public static enum ConversionType {
        TaggedString,
        TaggedNumber,
        UntaggedNumber;

    }
}

