/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.events.HasAxis;
import com.vaadin.flow.component.charts.model.XAxis;

@DomEvent(value="xaxes-extremes-set")
public class XAxesExtremesSetEvent
extends ComponentEvent<Chart>
implements HasAxis<XAxis> {
    private double minimum;
    private double maximum;
    private final int axisIndex;

    public XAxesExtremesSetEvent(Chart source, boolean fromClient, @EventData(value="event.detail.originalEvent.min") double min, @EventData(value="event.detail.originalEvent.max") double max, @EventData(value="event.detail.axis.userOptions.axisIndex") int axisIndex) {
        super((Component)source, fromClient);
        this.minimum = min;
        this.maximum = max;
        this.axisIndex = axisIndex;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public int getAxisIndex() {
        return this.axisIndex;
    }

    @Override
    public XAxis getAxis() {
        return ((Chart)this.getSource()).getConfiguration().getxAxis(this.axisIndex);
    }
}

