/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HtmlRadioButtonInput
extends HtmlInput {
    private static final String DEFAULT_VALUE = "on";
    private boolean defaultCheckedState_;
    private boolean forceChecked_;

    HtmlRadioButtonInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, HtmlRadioButtonInput.addValueIfNeeded(page, attributes));
        if (this.getAttribute("value") == DEFAULT_VALUE) {
            this.setDefaultValue(ATTRIBUTE_NOT_DEFINED, false);
        }
        this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        for (String key : attributes.keySet()) {
            if (!"value".equalsIgnoreCase(key)) continue;
            return attributes;
        }
        DomAttr newAttr = new DomAttr(page, null, "value", DEFAULT_VALUE, true);
        attributes.put("value", newAttr);
        return attributes;
    }

    @Override
    public void reset() {
        if (this.defaultCheckedState_) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
    }

    @Override
    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        HtmlForm form = this.getEnclosingForm();
        boolean changed = this.isChecked() != isChecked;
        Page page = this.getPage();
        if (isChecked) {
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else if (page != null && page.isHtmlPage()) {
                this.setCheckedForPage((HtmlPage)page);
            }
        } else {
            this.removeAttribute("checked");
        }
        if (changed && !this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS) && (scriptResult = this.fireEvent("change")) != null) {
            page = scriptResult.getNewPage();
        }
        return page;
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        HtmlForm form = this.getEnclosingForm();
        boolean changed = !this.isChecked();
        SgmlPage page = this.getPage();
        if (form != null) {
            form.setCheckedRadioButton(this);
        } else if (page != null && page.isHtmlPage()) {
            this.setCheckedForPage((HtmlPage)page);
        }
        super.doClickStateUpdate();
        return changed;
    }

    private void setCheckedForPage(HtmlPage htmlPage) {
        List<?> pageInputs = htmlPage.getByXPath("//input[lower-case(@type)='radio' and @name='" + this.getNameAttribute() + "']");
        List<?> formInputs = htmlPage.getByXPath("//form//input[lower-case(@type)='radio' and @name='" + this.getNameAttribute() + "']");
        pageInputs.removeAll(formInputs);
        boolean foundInPage = false;
        for (HtmlRadioButtonInput input : pageInputs) {
            if (input == this) {
                input.setAttribute("checked", "checked");
                foundInPage = true;
                continue;
            }
            input.removeAttribute("checked");
        }
        if (!foundInPage && !formInputs.contains(this)) {
            this.setAttribute("checked", "checked");
        }
    }

    @Override
    protected void doClickFireChangeEvent() throws IOException {
        if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS)) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    public String asText() {
        return super.asText();
    }

    @Override
    protected void preventDefault() {
        this.setChecked(!this.isChecked());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_DEFAULT_CHECKED_UPDATES_CHECKED)) {
            this.setChecked(this.isDefaultChecked());
        }
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_CHECKED_TO_FALSE_WHEN_CLONE)) {
            this.reset();
            this.forceChecked_ = true;
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void onAddedToPage() {
        super.onAddedToPage();
        if (this.forceChecked_) {
            return;
        }
        this.setChecked(this.isChecked());
    }

    @Override
    protected void onAddedToDocumentFragment() {
        super.onAddedToDocumentFragment();
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_CHECKED_TO_FALSE_WHEN_CLONE)) {
            this.forceChecked_ = true;
        }
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlRadioButtonInput clone = (HtmlRadioButtonInput)super.cloneNode(deep);
        clone.forceChecked_ = false;
        if (this.wasCreatedByJavascript() && this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_CHECKED_TO_FALSE_WHEN_CLONE)) {
            clone.removeAttribute("checked");
            clone.forceChecked_ = true;
        }
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_DEFAULT_VALUE_WHEN_CLONE)) {
            clone.setDefaultValue(this.getValueAttribute(), false);
        }
        return clone;
    }

    @Override
    Object getInternalValue() {
        return this.isChecked();
    }

    @Override
    void handleFocusLostValueChanged() {
        boolean fireOnChange = this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS);
        if (fireOnChange) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_DEFAULT_CHECKED_UPDATES_CHECKED) && "value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }
}

