/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.FunctionWrapper;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

class NativeFunctionToStringFunction
extends FunctionWrapper {
    private final String separator_;

    NativeFunctionToStringFunction(Function wrapped, String separator) {
        super(wrapped);
        this.separator_ = separator;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s = (String)super.call(cx, scope, thisObj, args);
        if (thisObj instanceof IdFunctionObject && s.contains("() { [native code for ")) {
            String functionName = ((IdFunctionObject)thisObj).getFunctionName();
            return this.separator_ + "function " + functionName + "() {\n    [native code]\n}" + this.separator_;
        }
        return s.trim();
    }

    static void installFix(Scriptable window, BrowserVersion browserVersion) {
        ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Function");
        Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, "toString");
        String separator = browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NEW_LINE) ? "\n" : "";
        NativeFunctionToStringFunction newToString = new NativeFunctionToStringFunction(originalToString, separator);
        ScriptableObject.putProperty((Scriptable)fnPrototype, "toString", (Object)newToString);
    }
}

