/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gwt.thirdparty.common.css.GssFunctionMapProvider;
import com.google.gwt.thirdparty.common.css.OutputRenamingMapFormat;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.SubstitutionMapProvider;
import com.google.gwt.thirdparty.common.css.Vendor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class JobDescription {
    public final List<SourceCode> inputs;
    public final String copyrightNotice;
    public final OutputFormat outputFormat;
    public final InputOrientation inputOrientation;
    public final OutputOrientation outputOrientation;
    public final OptimizeStrategy optimize;
    public final List<String> trueConditionNames;
    public final boolean useInternalBidiFlipper;
    public final boolean swapLtrRtlInUrl;
    public final boolean swapLeftRightInUrl;
    public final boolean simplifyCss;
    public final boolean eliminateDeadStyles;
    public final boolean allowUnrecognizedFunctions;
    public final Set<String> allowedNonStandardFunctions;
    public final boolean allowUnrecognizedProperties;
    public final Set<String> allowedUnrecognizedProperties;
    public final Vendor vendor;
    public final boolean allowKeyframes;
    public final boolean allowWebkitKeyframes;
    public final boolean processDependencies;
    public final ImmutableSet<String> allowedAtRules;
    public final String cssRenamingPrefix;
    public final List<String> excludedClassesFromRenaming;
    public final GssFunctionMapProvider gssFunctionMapProvider;
    public final SubstitutionMapProvider cssSubstitutionMapProvider;
    public final OutputRenamingMapFormat outputRenamingMapFormat;
    static final String CONDITION_FOR_LTR = "GSS_LTR";
    static final String CONDITION_FOR_RTL = "GSS_RTL";

    JobDescription(List<SourceCode> inputs, String copyrightNotice, OutputFormat outputFormat, InputOrientation inputOrientation, OutputOrientation outputOrientation, OptimizeStrategy optimize, List<String> trueConditionNames, boolean useInternalBidiFlipper, boolean swapLtrRtlInUrl, boolean swapLeftRightInUrl, boolean simplifyCss, boolean eliminateDeadStyles, boolean allowUnrecognizedFunctions, Set<String> allowedNonStandardFunctions, boolean allowUnrecognizedProperties, Set<String> allowedUnrecognizedProperties, Vendor vendor, boolean allowKeyframes, boolean allowWebkitKeyframes, boolean processDependencies, Set<String> allowedAtRules, String cssRenamingPrefix, List<String> excludedClassesFromRenaming, GssFunctionMapProvider gssFunctionMapProvider, SubstitutionMapProvider cssSubstitutionMapProvider, OutputRenamingMapFormat outputRenamingMapFormat) {
        Preconditions.checkArgument((!inputs.contains(null) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)outputFormat));
        Preconditions.checkNotNull((Object)((Object)inputOrientation));
        Preconditions.checkNotNull((Object)((Object)outputOrientation));
        Preconditions.checkNotNull((Object)((Object)optimize));
        Preconditions.checkNotNull(trueConditionNames);
        Preconditions.checkNotNull(allowedAtRules);
        Preconditions.checkNotNull(excludedClassesFromRenaming);
        this.inputs = ImmutableList.copyOf(inputs);
        this.copyrightNotice = copyrightNotice;
        this.outputFormat = outputFormat;
        this.inputOrientation = inputOrientation;
        this.outputOrientation = outputOrientation;
        this.optimize = optimize;
        this.trueConditionNames = ImmutableList.copyOf(trueConditionNames);
        this.useInternalBidiFlipper = useInternalBidiFlipper;
        this.swapLtrRtlInUrl = swapLtrRtlInUrl;
        this.swapLeftRightInUrl = swapLeftRightInUrl;
        this.simplifyCss = simplifyCss;
        this.eliminateDeadStyles = eliminateDeadStyles;
        this.allowUnrecognizedFunctions = allowUnrecognizedFunctions;
        this.allowedNonStandardFunctions = ImmutableSet.copyOf(allowedNonStandardFunctions);
        this.allowUnrecognizedProperties = allowUnrecognizedProperties;
        this.allowedUnrecognizedProperties = ImmutableSet.copyOf(allowedUnrecognizedProperties);
        this.vendor = vendor;
        this.allowKeyframes = allowKeyframes;
        this.allowWebkitKeyframes = allowWebkitKeyframes;
        this.processDependencies = processDependencies;
        this.allowedAtRules = ImmutableSet.copyOf(allowedAtRules);
        this.cssRenamingPrefix = cssRenamingPrefix;
        this.excludedClassesFromRenaming = ImmutableList.copyOf(excludedClassesFromRenaming);
        this.gssFunctionMapProvider = gssFunctionMapProvider;
        this.cssSubstitutionMapProvider = cssSubstitutionMapProvider;
        this.outputRenamingMapFormat = outputRenamingMapFormat;
    }

    public int getAllInputsLength() {
        int totalLength = 0;
        for (SourceCode input : this.inputs) {
            totalLength += input.getFileContentsLength();
        }
        return totalLength;
    }

    static boolean orientationsAreTheSame(InputOrientation inputOrientation, OutputOrientation outputOrientation) {
        return inputOrientation.toString().equals(outputOrientation.toString());
    }

    public boolean needsBiDiFlipping() {
        return this.outputOrientation != OutputOrientation.NOCHANGE && !JobDescription.orientationsAreTheSame(this.inputOrientation, this.outputOrientation);
    }

    public static enum OptimizeStrategy {
        NONE,
        SAFE,
        MAXIMUM;

    }

    public static enum OutputOrientation {
        LTR,
        RTL,
        NOCHANGE;

    }

    public static enum InputOrientation {
        LTR,
        RTL;

    }

    public static enum OutputFormat {
        DEBUG,
        COMPRESSED,
        PRETTY_PRINTED;

    }
}

