/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gwt.thirdparty.common.css.GssFunctionMapProvider;
import com.google.gwt.thirdparty.common.css.JobDescription;
import com.google.gwt.thirdparty.common.css.OutputRenamingMapFormat;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.SubstitutionMapProvider;
import com.google.gwt.thirdparty.common.css.Vendor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JobDescriptionBuilder {
    private List<SourceCode> inputs = Lists.newArrayList();
    private String copyrightNotice = null;
    private JobDescription.OutputFormat outputFormat = JobDescription.OutputFormat.COMPRESSED;
    private JobDescription.InputOrientation inputOrientation = JobDescription.InputOrientation.LTR;
    private JobDescription.OutputOrientation outputOrientation = JobDescription.OutputOrientation.LTR;
    private JobDescription.OptimizeStrategy optimize = JobDescription.OptimizeStrategy.SAFE;
    private List<String> trueConditionNames = Lists.newArrayList();
    private boolean useInternalBidiFlipper = false;
    private boolean swapLtrRtlInUrl = false;
    private boolean swapLeftRightInUrl = false;
    private boolean simplifyCss = false;
    private boolean eliminateDeadStyles = false;
    private boolean allowUnrecognizedFunctions = false;
    private Set<String> allowedNonStandardFunctions = Sets.newHashSet();
    private boolean allowUnrecognizedProperties = false;
    private Set<String> allowedUnrecognizedProperties = Sets.newHashSet();
    private Vendor vendor = null;
    private boolean allowKeyframes = true;
    private boolean allowWebkitKeyframes = true;
    private boolean processDependencies = false;
    private String cssRenamingPrefix = "";
    private List<String> excludedClassesFromRenaming = Lists.newArrayList();
    private GssFunctionMapProvider gssFunctionMapProvider = null;
    private SubstitutionMapProvider cssSubstitutionMapProvider = null;
    private OutputRenamingMapFormat outputRenamingMapFormat = OutputRenamingMapFormat.JSCOMP_VARIABLE_MAP;
    private JobDescription job = null;

    public JobDescriptionBuilder copyFrom(JobDescription jobToCopy) {
        this.setInputs(Lists.newArrayList(jobToCopy.inputs));
        this.copyrightNotice = jobToCopy.copyrightNotice;
        this.setOutputFormat(jobToCopy.outputFormat);
        this.setInputOrientation(jobToCopy.inputOrientation);
        this.setOutputOrientation(jobToCopy.outputOrientation);
        this.optimize = jobToCopy.optimize;
        this.setTrueConditionNames(Lists.newArrayList(jobToCopy.trueConditionNames));
        this.useInternalBidiFlipper = jobToCopy.useInternalBidiFlipper;
        this.swapLtrRtlInUrl = jobToCopy.swapLtrRtlInUrl;
        this.swapLeftRightInUrl = jobToCopy.swapLeftRightInUrl;
        this.simplifyCss = jobToCopy.simplifyCss;
        this.eliminateDeadStyles = jobToCopy.eliminateDeadStyles;
        this.allowUnrecognizedFunctions = jobToCopy.allowUnrecognizedFunctions;
        this.allowedNonStandardFunctions = ImmutableSet.copyOf(jobToCopy.allowedNonStandardFunctions);
        this.allowUnrecognizedProperties = jobToCopy.allowUnrecognizedProperties;
        this.allowedUnrecognizedProperties = ImmutableSet.copyOf(jobToCopy.allowedUnrecognizedProperties);
        this.vendor = jobToCopy.vendor;
        this.allowKeyframes = jobToCopy.allowKeyframes;
        this.allowWebkitKeyframes = jobToCopy.allowWebkitKeyframes;
        this.cssRenamingPrefix = jobToCopy.cssRenamingPrefix;
        this.setExcludedClassesFromRenaming((List<String>)ImmutableList.copyOf(jobToCopy.excludedClassesFromRenaming));
        this.gssFunctionMapProvider = jobToCopy.gssFunctionMapProvider;
        this.cssSubstitutionMapProvider = jobToCopy.cssSubstitutionMapProvider;
        this.outputRenamingMapFormat = jobToCopy.outputRenamingMapFormat;
        return this;
    }

    private void checkJobIsNotAlreadyCreated() {
        Preconditions.checkState((this.job == null ? 1 : 0) != 0, (Object)"You cannot set job properties after the message was created.");
    }

    public JobDescriptionBuilder clearInputs() {
        this.checkJobIsNotAlreadyCreated();
        this.inputs.clear();
        return this;
    }

    public JobDescriptionBuilder setInputs(List<SourceCode> newInputs) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.inputs.isEmpty());
        Preconditions.checkArgument((!newInputs.contains(null) ? 1 : 0) != 0);
        this.inputs = Lists.newArrayList(newInputs);
        return this;
    }

    public JobDescriptionBuilder addInput(SourceCode sourceCode) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)sourceCode);
        this.inputs.add(sourceCode);
        return this;
    }

    public JobDescriptionBuilder setOptimizeStrategy(JobDescription.OptimizeStrategy optimize) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)optimize));
        this.optimize = optimize;
        return this;
    }

    public JobDescriptionBuilder clearTrueConditionNames() {
        this.checkJobIsNotAlreadyCreated();
        this.trueConditionNames.clear();
        return this;
    }

    public JobDescriptionBuilder setTrueConditionNames(List<String> newTrueConditionNames) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.trueConditionNames.isEmpty());
        Preconditions.checkArgument((!newTrueConditionNames.contains(null) ? 1 : 0) != 0);
        this.trueConditionNames = Lists.newArrayList(newTrueConditionNames);
        return this;
    }

    public JobDescriptionBuilder addTrueConditionName(String conditionName) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)conditionName);
        this.trueConditionNames.add(conditionName);
        return this;
    }

    public JobDescriptionBuilder setExcludedClassesFromRenaming(List<String> excludedClassesFromRenaming) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.excludedClassesFromRenaming.isEmpty());
        Preconditions.checkArgument((!excludedClassesFromRenaming.contains(null) ? 1 : 0) != 0);
        this.excludedClassesFromRenaming = Lists.newArrayList(excludedClassesFromRenaming);
        return this;
    }

    public JobDescriptionBuilder setCssRenamingPrefix(String cssRenamingPrefix) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)cssRenamingPrefix);
        this.cssRenamingPrefix = cssRenamingPrefix;
        return this;
    }

    public JobDescriptionBuilder setCopyrightNotice(String copyrightNotice) {
        this.checkJobIsNotAlreadyCreated();
        this.copyrightNotice = copyrightNotice;
        return this;
    }

    public JobDescriptionBuilder setUseInternalBidiFlipper(boolean use) {
        this.checkJobIsNotAlreadyCreated();
        this.useInternalBidiFlipper = use;
        return this;
    }

    public JobDescriptionBuilder useInternalBidiFlipper() {
        return this.setUseInternalBidiFlipper(true);
    }

    public JobDescriptionBuilder setSwapLtrRtlInUrl(boolean swap) {
        this.checkJobIsNotAlreadyCreated();
        if (this.useInternalBidiFlipper) {
            this.swapLtrRtlInUrl = swap;
        }
        return this;
    }

    public JobDescriptionBuilder swapLtrRtlInUrl() {
        return this.setSwapLtrRtlInUrl(true);
    }

    public JobDescriptionBuilder setSwapLeftRightInUrl(boolean swap) {
        this.checkJobIsNotAlreadyCreated();
        if (this.useInternalBidiFlipper) {
            this.swapLeftRightInUrl = swap;
        }
        return this;
    }

    public JobDescriptionBuilder swapLeftRightInUrl() {
        return this.setSwapLeftRightInUrl(true);
    }

    public JobDescriptionBuilder setInputOrientation(JobDescription.InputOrientation newInputOrientation) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newInputOrientation));
        this.inputOrientation = newInputOrientation;
        return this;
    }

    public JobDescriptionBuilder setOutputOrientation(JobDescription.OutputOrientation newOutputOrientation) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newOutputOrientation));
        this.outputOrientation = newOutputOrientation;
        return this;
    }

    public JobDescriptionBuilder setOutputFormat(JobDescription.OutputFormat newOutputFormat) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newOutputFormat));
        this.outputFormat = newOutputFormat;
        return this;
    }

    public JobDescriptionBuilder setSimplifyCss(boolean simplify) {
        this.checkJobIsNotAlreadyCreated();
        this.simplifyCss = simplify;
        return this;
    }

    public JobDescriptionBuilder simplifyCss() {
        return this.setSimplifyCss(true);
    }

    public JobDescriptionBuilder setEliminateDeadStyles(boolean eliminate) {
        this.checkJobIsNotAlreadyCreated();
        this.eliminateDeadStyles = eliminate;
        return this;
    }

    public JobDescriptionBuilder eliminateDeadStyles() {
        return this.setEliminateDeadStyles(true);
    }

    public JobDescriptionBuilder setGssFunctionMapProvider(GssFunctionMapProvider gssFunctionMapProvider) {
        this.checkJobIsNotAlreadyCreated();
        this.gssFunctionMapProvider = gssFunctionMapProvider;
        return this;
    }

    public JobDescriptionBuilder setCssSubstitutionMapProvider(SubstitutionMapProvider cssSubstitutionMapProvider) {
        this.checkJobIsNotAlreadyCreated();
        this.cssSubstitutionMapProvider = cssSubstitutionMapProvider;
        return this;
    }

    public JobDescriptionBuilder setAllowUnrecognizedFunctions(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowUnrecognizedFunctions = allow;
        return this;
    }

    public JobDescriptionBuilder allowUnrecognizedFunctions() {
        return this.setAllowUnrecognizedFunctions(true);
    }

    public JobDescriptionBuilder setAllowedNonStandardFunctions(List<String> functionNames) {
        this.checkJobIsNotAlreadyCreated();
        this.allowedNonStandardFunctions.addAll(functionNames);
        return this;
    }

    public JobDescriptionBuilder setAllowUnrecognizedProperties(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowUnrecognizedProperties = allow;
        return this;
    }

    public JobDescriptionBuilder allowUnrecognizedProperties() {
        return this.setAllowUnrecognizedProperties(true);
    }

    public JobDescriptionBuilder setAllowedUnrecognizedProperties(List<String> propertyNames) {
        this.checkJobIsNotAlreadyCreated();
        this.allowedUnrecognizedProperties.addAll(propertyNames);
        return this;
    }

    public JobDescriptionBuilder setVendor(Vendor vendor) {
        this.checkJobIsNotAlreadyCreated();
        this.vendor = vendor;
        return this;
    }

    public JobDescriptionBuilder setAllowKeyframes(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowKeyframes = allow;
        return this;
    }

    public JobDescriptionBuilder allowKeyframes() {
        return this.setAllowKeyframes(true);
    }

    public JobDescriptionBuilder setAllowWebkitKeyframes(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowWebkitKeyframes = allow;
        return this;
    }

    public JobDescriptionBuilder allowWebkitKeyframes() {
        return this.setAllowWebkitKeyframes(true);
    }

    public JobDescriptionBuilder setProcessDependencies(boolean process) {
        this.checkJobIsNotAlreadyCreated();
        this.processDependencies = process;
        return this;
    }

    public JobDescriptionBuilder setOutputRenamingMapFormat(OutputRenamingMapFormat format) {
        this.checkJobIsNotAlreadyCreated();
        this.outputRenamingMapFormat = format;
        return this;
    }

    public JobDescription getJobDescription() {
        if (this.job != null) {
            return this.job;
        }
        HashSet allowedAtRules = Sets.newHashSet();
        this.job = new JobDescription(this.inputs, this.copyrightNotice, this.outputFormat, this.inputOrientation, this.outputOrientation, this.optimize, this.trueConditionNames, this.useInternalBidiFlipper, this.swapLtrRtlInUrl, this.swapLeftRightInUrl, this.simplifyCss, this.eliminateDeadStyles, this.allowUnrecognizedFunctions, this.allowedNonStandardFunctions, this.allowUnrecognizedProperties, this.allowedUnrecognizedProperties, this.vendor, this.allowKeyframes, this.allowWebkitKeyframes, this.processDependencies, allowedAtRules, this.cssRenamingPrefix, this.excludedClassesFromRenaming, this.gssFunctionMapProvider, this.cssSubstitutionMapProvider, this.outputRenamingMapFormat);
        return this.job;
    }
}

