/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gwt.thirdparty.common.css.MultipleMappingSubstitutionMap;
import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class RecordingSubstitutionMap
implements SubstitutionMap {
    private final SubstitutionMap delegate;
    private final Predicate<? super String> shouldRecordMappingForCodeGeneration;
    private final Map<String, String> mappings;
    @Nullable
    private final MultipleMappingSubstitutionMap multipleMappingSubstitutionMap;

    public RecordingSubstitutionMap(SubstitutionMap map, Predicate<? super String> shouldRecordMappingForCodeGeneration) {
        this.delegate = map;
        this.shouldRecordMappingForCodeGeneration = shouldRecordMappingForCodeGeneration;
        this.mappings = Maps.newLinkedHashMap();
        this.multipleMappingSubstitutionMap = map instanceof MultipleMappingSubstitutionMap ? (MultipleMappingSubstitutionMap)map : null;
    }

    @Override
    public String get(String key) {
        Preconditions.checkNotNull((Object)key);
        if (!this.shouldRecordMappingForCodeGeneration.apply((Object)key)) {
            return key;
        }
        if (this.mappings.containsKey(key)) {
            return this.mappings.get(key);
        }
        if (this.multipleMappingSubstitutionMap != null) {
            MultipleMappingSubstitutionMap.ValueWithMappings valueWithMappings = this.multipleMappingSubstitutionMap.getValueWithMappings(key);
            this.mappings.putAll(valueWithMappings.mappings);
            return valueWithMappings.value;
        }
        String value = this.delegate.get(key);
        this.mappings.put(key, value);
        return value;
    }

    public Map<String, String> getMappings() {
        return ImmutableMap.copyOf(this.mappings);
    }
}

