/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.primitives.Ints;
import javax.annotation.Nullable;

public class SourceCodeLocation
implements Comparable<SourceCodeLocation> {
    private static final SourceCode UNKNOWN_SOURCE_CODE = new SourceCode("unknown", "");
    private final SourceCode sourceCode;
    private final SourceCodePoint begin;
    private final SourceCodePoint end;

    public static SourceCodeLocation getUnknownLocation() {
        SourceCodeLocation result = new SourceCodeLocation(UNKNOWN_SOURCE_CODE, -1, 0, 0, -1, 0, 0);
        Preconditions.checkState((boolean)result.isUnknown());
        Preconditions.checkState((boolean)result.begin.hasValidUnknownCoordinates());
        Preconditions.checkState((boolean)result.end.hasValidUnknownCoordinates());
        return result;
    }

    @VisibleForTesting
    public SourceCodeLocation(SourceCode sourceCode, int beginCharacterIndex, int beginLineNumber, int beginIndexInLine, int endCharacterIndex, int endLineNumber, int endIndexInLine) {
        Preconditions.checkNotNull((Object)sourceCode);
        this.sourceCode = sourceCode;
        this.begin = new SourceCodePoint(beginCharacterIndex, beginLineNumber, beginIndexInLine);
        this.end = new SourceCodePoint(endCharacterIndex, endLineNumber, endIndexInLine);
        Preconditions.checkArgument((this.begin.compareTo(this.end) <= 0 ? 1 : 0) != 0, (Object)"Beginning location must come before the end location.");
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public boolean isUnknown() {
        Preconditions.checkState((this.begin.isUnknown() == this.end.isUnknown() ? 1 : 0) != 0);
        return this.begin.isUnknown();
    }

    public int getBeginCharacterIndex() {
        return this.begin.getCharacterIndex();
    }

    public int getBeginLineNumber() {
        return this.begin.getLineNumber();
    }

    public int getBeginIndexInLine() {
        return this.begin.getIndexInLine();
    }

    public int getEndCharacterIndex() {
        return this.end.getCharacterIndex();
    }

    public int getEndLineNumber() {
        return this.end.getLineNumber();
    }

    public int getEndIndexInLine() {
        return this.end.getIndexInLine();
    }

    public int getCharacterIndex() {
        return this.getBeginCharacterIndex();
    }

    public int getLineNumber() {
        return this.getBeginLineNumber();
    }

    public int getIndexInLine() {
        return this.getBeginIndexInLine();
    }

    public SourceCodePoint getBegin() {
        return this.begin;
    }

    public SourceCodePoint getEnd() {
        return this.end;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SourceCodeLocation)) {
            return false;
        }
        SourceCodeLocation other = (SourceCodeLocation)o;
        return this.sourceCode == other.sourceCode && this.begin.equals(other.begin) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.sourceCode.hashCode() ^ this.begin.hashCode() ^ this.end.hashCode() << 16;
    }

    @Override
    public int compareTo(SourceCodeLocation o) {
        Preconditions.checkNotNull((Object)o);
        if (this.sourceCode != o.sourceCode) {
            if (this.sourceCode == null) {
                return -1;
            }
            if (o.sourceCode == null) {
                return 1;
            }
            return this.sourceCode.hashCode() - o.sourceCode.hashCode();
        }
        int startPointsComparison = this.begin.compareTo(o.begin);
        if (startPointsComparison != 0) {
            return startPointsComparison;
        }
        return this.end.compareTo(o.end);
    }

    @VisibleForTesting
    public static class SourceCodePoint
    implements Comparable<SourceCodePoint> {
        private final int characterIndex;
        private final int lineNumber;
        private final int indexInLine;

        SourceCodePoint(int characterIndex, int lineNumber, int indexInLine) {
            this.lineNumber = lineNumber;
            this.indexInLine = indexInLine;
            this.characterIndex = characterIndex;
            if (!this.hasValidKnownCoordinates() && !this.hasValidUnknownCoordinates()) {
                throw new IllegalArgumentException(String.format("The location passed (lineNumber %d, indexInLine %d, characterIndex %d) is not valid.", lineNumber, indexInLine, characterIndex));
            }
            if (!this.hasPlausibleCoordinates()) {
                throw new IllegalArgumentException(String.format("The location passed (lineNumber %d, indexInLine %d, characterIndex %d) is not plausible.", lineNumber, indexInLine, characterIndex));
            }
        }

        SourceCodePoint(SourceCodePoint that) {
            this(that.characterIndex, that.lineNumber, that.indexInLine);
        }

        boolean hasValidKnownCoordinates() {
            return this.lineNumber >= 1 && this.indexInLine >= 1 && this.characterIndex >= 0;
        }

        boolean hasValidUnknownCoordinates() {
            return this.characterIndex == -1 && this.lineNumber == 0 && this.indexInLine == 0;
        }

        boolean hasPlausibleCoordinates() {
            return this.characterIndex >= this.lineNumber - 1 + this.indexInLine - 1;
        }

        int getCharacterIndex() {
            return this.characterIndex;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        int getIndexInLine() {
            return this.indexInLine;
        }

        boolean isUnknown() {
            return this.characterIndex == -1;
        }

        public boolean equals(@Nullable Object o) {
            boolean areEqual;
            if (o == null) {
                return false;
            }
            if (!(o instanceof SourceCodePoint)) {
                return false;
            }
            SourceCodePoint other = (SourceCodePoint)o;
            boolean bl = areEqual = this.characterIndex == other.characterIndex;
            if (areEqual) {
                Preconditions.checkState((this.lineNumber == other.lineNumber && this.indexInLine == other.indexInLine ? 1 : 0) != 0, (Object)"Character indexes are equal but line numbers and indexes within the line do not match.");
            } else {
                Preconditions.checkState((this.lineNumber != other.lineNumber || this.indexInLine != other.indexInLine ? 1 : 0) != 0, (Object)"Line numbers and indexes within the line match but character indexes are not equal");
            }
            return areEqual;
        }

        public int hashCode() {
            return this.characterIndex;
        }

        @Override
        public int compareTo(SourceCodePoint o) {
            Preconditions.checkNotNull((Object)o);
            return Ints.compare((int)this.characterIndex, (int)o.characterIndex);
        }
    }
}

