/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import javax.annotation.Nullable;

public class CssComponentNode
extends CssAtRuleNode {
    public static final String IMPLICIT_NODE_NAME = "$package";
    private final CssLiteralNode parentName;
    private final PrefixStyle prefixStyle;

    public CssComponentNode(CssLiteralNode name, @Nullable CssLiteralNode parentName, boolean isAbstract, PrefixStyle prefixStyle, CssBlockNode block) {
        super(isAbstract ? CssAtRuleNode.Type.ABSTRACT_COMPONENT : CssAtRuleNode.Type.COMPONENT, name, block);
        this.parentName = parentName;
        this.prefixStyle = prefixStyle;
    }

    public CssComponentNode(CssComponentNode node) {
        super(node);
        this.parentName = node.parentName;
        this.prefixStyle = node.prefixStyle;
    }

    @Override
    public CssNode deepCopy() {
        return new CssComponentNode(this);
    }

    public CssLiteralNode getParentName() {
        return this.parentName;
    }

    public boolean isAbstract() {
        return this.getType() == CssAtRuleNode.Type.ABSTRACT_COMPONENT;
    }

    public boolean isImplicitlyNamed() {
        return this.getName().getValue() == IMPLICIT_NODE_NAME;
    }

    public PrefixStyle getPrefixStyle() {
        return this.prefixStyle;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().toString()).append(' ');
        if (!this.isImplicitlyNamed()) {
            sb.append(this.getName().getValue()).append(' ');
        }
        if (this.parentName != null) {
            sb.append("extends ").append(this.parentName.getValue()).append(' ');
        }
        sb.append('{').append(this.getBlock().toString()).append('}');
        return sb.toString();
    }

    @Override
    public CssBlockNode getBlock() {
        return (CssBlockNode)super.getBlock();
    }

    public static enum PrefixStyle {
        LITERAL,
        CASE_CONVERT;

    }
}

