/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class CssConditionalRuleNode
extends CssAtRuleNode {
    public CssConditionalRuleNode(CssAtRuleNode.Type type, CssLiteralNode name) {
        super(type, name);
        Preconditions.checkArgument((boolean)this.getType().isConditional());
    }

    public CssConditionalRuleNode(CssAtRuleNode.Type type, CssLiteralNode name, @Nullable CssBooleanExpressionNode condition, CssBlockNode block) {
        super(type, name, block);
        Preconditions.checkArgument((boolean)this.getType().isConditional());
        if (condition != null) {
            this.setCondition(condition);
        }
    }

    public CssConditionalRuleNode(CssConditionalRuleNode node) {
        super(node);
        if (node.getCondition() != null) {
            this.setCondition(node.getCondition().deepCopy());
        }
    }

    @Override
    public CssConditionalRuleNode deepCopy() {
        return new CssConditionalRuleNode(this);
    }

    @Override
    void setParent(CssNode parent) {
        Preconditions.checkArgument((boolean)(parent instanceof CssConditionalBlockNode));
        super.setParent(parent);
    }

    public CssBooleanExpressionNode getCondition() {
        if (this.getType() == CssAtRuleNode.Type.ELSE) {
            Preconditions.checkState((this.getParametersCount() == 0 ? 1 : 0) != 0);
            return null;
        }
        Preconditions.checkState((this.getParametersCount() == 1 ? 1 : 0) != 0);
        return (CssBooleanExpressionNode)this.getParameters().get(0);
    }

    void setCondition(CssBooleanExpressionNode condition) {
        Preconditions.checkState((this.getType() != CssAtRuleNode.Type.ELSE ? 1 : 0) != 0);
        Preconditions.checkState((this.getParametersCount() <= 1 ? 1 : 0) != 0);
        this.setParameters((List<CssValueNode>)ImmutableList.of((Object)condition));
    }

    @Override
    public CssBlockNode getBlock() {
        return (CssBlockNode)super.getBlock();
    }
}

