/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.Proxiable;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CssCustomFunctionNode
extends CssFunctionNode
implements Proxiable<CssCustomFunctionNode> {
    private final String gssFunctionName;
    protected List<CssValueNode> resultNodes;

    public CssCustomFunctionNode(String gssFunctionName, SourceCodeLocation sourceCodeLocation) {
        super(CssFunctionNode.Function.CUSTOM, sourceCodeLocation);
        this.gssFunctionName = gssFunctionName;
    }

    public CssCustomFunctionNode(CssCustomFunctionNode function) {
        super(function);
        this.gssFunctionName = function.getFunctionName();
    }

    private CssCustomFunctionNode(@Nullable SourceCodeLocation sourceCodeLocation, String gssFunctionName) {
        super(sourceCodeLocation, CssFunctionNode.Function.CUSTOM);
        this.gssFunctionName = gssFunctionName;
    }

    @Override
    public CssCustomFunctionNode deepCopy() {
        return new CssCustomFunctionNode(this);
    }

    @Override
    public String getFunctionName() {
        return this.gssFunctionName;
    }

    @Override
    public String toString() {
        return this.gssFunctionName + super.toString();
    }

    @Override
    public void setArguments(CssFunctionArgumentsNode arguments) {
        this.resultNodes = null;
        super.setArguments(arguments);
    }

    @Override
    public CssCustomFunctionNode createProxy() {
        return new CssCustomFunctionNodeProxy(this);
    }

    public List<CssValueNode> getResult() {
        return this.resultNodes;
    }

    public void setResult(List<CssValueNode> functionResult) {
        this.resultNodes = functionResult;
    }

    public static class CssCustomFunctionNodeProxy
    extends CssCustomFunctionNode {
        private CssCustomFunctionNode proxiedNode;

        public CssCustomFunctionNodeProxy(CssCustomFunctionNode function) {
            super(function.getSourceCodeLocation(), function.getFunctionName());
            this.proxiedNode = function;
            this.setChunk(function.getChunk());
        }

        @Override
        public CssFunctionArgumentsNode getArguments() {
            return this.proxiedNode != null ? this.proxiedNode.getArguments() : super.getArguments();
        }

        @Override
        public void setArguments(CssFunctionArgumentsNode arguments) {
            this.proxiedNode = null;
            super.setArguments(arguments);
        }

        @Override
        public CssCustomFunctionNode createProxy() {
            CssCustomFunctionNode newProxiedNode = this.proxiedNode != null ? this.proxiedNode : this;
            return new CssCustomFunctionNodeProxy(newProxiedNode);
        }

        @Override
        public List<CssValueNode> getResult() {
            if (this.proxiedNode == null) {
                return super.getResult();
            }
            List<CssValueNode> proxiedNodeResults = this.proxiedNode.getResult();
            if (proxiedNodeResults == null) {
                return null;
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)proxiedNodeResults.size());
            for (CssValueNode cssValueNode : proxiedNodeResults) {
                result.add(cssValueNode.deepCopy());
            }
            return result;
        }

        @Override
        public void setResult(List<CssValueNode> functionResult) {
            if (this.proxiedNode == null) {
                super.setResult(functionResult);
            } else {
                this.proxiedNode.setResult(functionResult);
            }
        }
    }
}

