/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;

public class CssMixinNode
extends CssAtRuleNode {
    private final String definitionName;
    private final CssFunctionArgumentsNode args;

    public CssMixinNode(String definitionName, CssFunctionArgumentsNode args, SourceCodeLocation location) {
        super(CssAtRuleNode.Type.MIXIN, new CssLiteralNode("mixin"));
        this.definitionName = definitionName;
        this.args = args;
        super.setSourceCodeLocation(location);
        this.becomeParentForNode(args);
    }

    public CssMixinNode(CssMixinNode node) {
        super(node);
        this.definitionName = new String(node.definitionName);
        this.args = node.args.deepCopy();
    }

    @Override
    public CssMixinNode deepCopy() {
        CssMixinNode copy = new CssMixinNode(this);
        copy.setSourceCodeLocation(this.getSourceCodeLocation());
        return copy;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public CssFunctionArgumentsNode getArguments() {
        return this.args;
    }
}

