/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.Property;
import javax.annotation.Nullable;

public class CssPropertyNode
extends CssValueNode {
    private final Property property;

    public CssPropertyNode(String value) {
        this(value, null);
    }

    public CssPropertyNode(String value, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(value, sourceCodeLocation);
        String propertyName = value.toLowerCase();
        this.property = Property.byName(propertyName);
    }

    public CssPropertyNode(CssPropertyNode node) {
        super(node);
        this.property = node.property;
    }

    @Override
    public CssPropertyNode deepCopy() {
        return new CssPropertyNode(this);
    }

    public Property getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.property.getName();
    }

    public String getPartition() {
        return this.property.getPartition();
    }

    @Override
    public String toString() {
        return this.property.getName();
    }
}

