/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.commandline;

import com.google.gwt.thirdparty.common.css.AbstractCommandLineCompiler;
import com.google.gwt.thirdparty.common.css.DefaultExitCodeHandler;
import com.google.gwt.thirdparty.common.css.ExitCodeHandler;
import com.google.gwt.thirdparty.common.css.GssFunctionMapProvider;
import com.google.gwt.thirdparty.common.css.JobDescription;
import com.google.gwt.thirdparty.common.css.JobDescriptionBuilder;
import com.google.gwt.thirdparty.common.css.OutputRenamingMapFormat;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.Vendor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.commandline.DefaultCommandLineCompiler;
import com.google.gwt.thirdparty.common.css.compiler.commandline.RenamingType;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ClosureCommandLineCompiler
extends DefaultCommandLineCompiler {
    protected ClosureCommandLineCompiler(JobDescription job, ExitCodeHandler exitCodeHandler, ErrorManager errorManager) {
        super(job, exitCodeHandler, errorManager);
    }

    private static GssFunctionMapProvider getGssFunctionMapProviderForName(String gssFunctionMapProviderClassName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(gssFunctionMapProviderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Class does not exist: %s", gssFunctionMapProviderClassName), e);
        }
        if (!GssFunctionMapProvider.class.isAssignableFrom(clazz)) {
            throw new RuntimeException(String.format("%s does not implement GssFunctionMapProvider", gssFunctionMapProviderClassName));
        }
        try {
            return (GssFunctionMapProvider)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void executeJob(JobDescription job, ExitCodeHandler exitCodeHandler, OutputInfo outputInfo) {
        DefaultCommandLineCompiler.CompilerErrorManager errorManager = new DefaultCommandLineCompiler.CompilerErrorManager();
        ClosureCommandLineCompiler compiler = new ClosureCommandLineCompiler(job, exitCodeHandler, errorManager);
        String compilerOutput = compiler.execute(outputInfo.renameFile);
        if (outputInfo.outputFile == null) {
            System.out.print(compilerOutput);
        } else {
            try {
                Files.write((CharSequence)compilerOutput, (File)outputInfo.outputFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                AbstractCommandLineCompiler.exitOnUnhandledException(e, exitCodeHandler);
            }
        }
    }

    @Nullable
    private static Flags parseArgs(String[] args, ExitCodeHandler exitCodeHandler) {
        Flags flags = new Flags();
        CmdLineParser argsParser = new CmdLineParser(flags){

            public void printUsage(OutputStream out) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
                writer.write(Flags.USAGE_PREAMBLE);
                writer.flush();
                super.printUsage(out);
            }
        };
        try {
            argsParser.parseArgument(args);
        }
        catch (CmdLineException e) {
            argsParser.printUsage((OutputStream)System.err);
            exitCodeHandler.processExitCode(1);
            return null;
        }
        if (flags.arguments.isEmpty()) {
            System.err.println("\nERROR: No input files specified.\n");
            argsParser.printUsage((OutputStream)System.err);
            exitCodeHandler.processExitCode(1);
            return null;
        }
        return flags;
    }

    public static void main(String[] args) {
        DefaultExitCodeHandler exitCodeHandler = new DefaultExitCodeHandler();
        Flags flags = ClosureCommandLineCompiler.parseArgs(args, exitCodeHandler);
        if (flags == null) {
            return;
        }
        JobDescription job = flags.createJobDescription();
        OutputInfo info = flags.createOutputInfo();
        ClosureCommandLineCompiler.executeJob(job, exitCodeHandler, info);
    }

    private static class OutputInfo {
        @Nullable
        public final File outputFile;
        @Nullable
        public final File renameFile;

        private OutputInfo(File outputFile, File renameFile) {
            this.outputFile = outputFile;
            this.renameFile = renameFile;
        }
    }

    private static class Flags {
        private static final String USAGE_PREAMBLE = Joiner.on((String)"\n").join((Object[])new String[]{"Closure Stylesheets", "", "One or more CSS/GSS files must be supplied as inputs.", "Output will be written to standard out unless --output_file is specified.", "", "command line options:", ""});
        @Option(name="--output-file", aliases={"-o"}, usage="The output CSS filename. If empty, standard output will be used. The output is always UTF-8 encoded.")
        private String outputFile = null;
        @Option(name="--input-orientation", usage="This specifies the display orientation the input files were written for. You can choose between: LTR, RTL. LTR is the default and means that the input style sheets were designed for use with left to right display User Agents. RTL sheets are designed for use with right to left UAs. Currently, all input files must have the same orientation, as there is no way to specify the orientation on a per-file or per-library basis.")
        private JobDescription.InputOrientation inputOrientation = JobDescription.InputOrientation.LTR;
        @Option(name="--output-orientation", usage="Specify this option to perform automatic right to left conversion of the input. You can choose between: LTR, RTL, NOCHANGE. NOCHANGE means the input will not be changed in any way with respect to direction issues. LTR outputs a sheet suitable for left to right display and RTL outputs a sheet suitable for right to left display. If the input orientation is different than the requested output orientation, 'left' and 'right' values in direction sensitive style rules are flipped. If the input already has the desired orientation, this option effectively does nothing except for defining GSS_LTR and GSS_RTL, respectively. The input is LTR by default and can be changed with the input_orientation flag.")
        private JobDescription.OutputOrientation outputOrientation = JobDescription.OutputOrientation.LTR;
        @Option(name="--pretty-print", usage="Whether to format the output with newlines and indents so that it is more readable.")
        private boolean prettyPrint = false;
        @Option(name="--output-renaming-map", usage="The output from the CSS class renaming. Provides a map of class names to what they were renammed to.")
        private String renameFile = null;
        @Option(name="--output-renaming-map-format", usage="How to format the output from the CSS class renaming.")
        private OutputRenamingMapFormat outputRenamingMapFormat = OutputRenamingMapFormat.JSON;
        @Option(name="--copyright-notice", usage="Copyright notice to prepend to the output")
        private String copyrightNotice = null;
        @Option(name="--define", usage="Specifies the name of a true condition. The condition name can be used in @if boolean expressions. The conditions are ignored if GSS extensions are not enabled.")
        private List<String> trueConditions = Lists.newArrayList();
        @Option(name="--allow-unrecognized-functions", usage="Allow unrecognized functions.")
        private boolean allowUnrecognizedFunctions = false;
        @Option(name="--allowed-non-standard-function", usage="Specify a non-standard function to whitelist, like alpha()")
        private List<String> allowedNonStandardFunctions = Lists.newArrayList();
        @Option(name="--allowed-unrecognized-property", usage="Specify an unrecognized property to whitelist")
        private List<String> allowedUnrecognizedProperties = Lists.newArrayList();
        @Option(name="--allow-unrecognized-properties", usage="Allow unrecognized properties.")
        private boolean allowUnrecognizedProperties = false;
        @Option(name="--vendor", usage="Creates browser-vendor-specific output by stripping all proprietary browser-vendor properties from the output except for those associated with this vendor.")
        private Vendor vendor = null;
        @Option(name="--excluded-classes-from-renaming", usage="Pass the compiler a list of CSS class names that shoudn't be renamed.")
        private List<String> excludedClassesFromRenaming = Lists.newArrayList();
        @Option(name="--rename", usage="How CSS classes should be renamed. Defaults to NONE.")
        private RenamingType renamingType = RenamingType.NONE;
        @Option(name="--gss-function-map-provider", usage="The fully qualified class name of a map provider of custom GSS functions to resolve.")
        private String gssFunctionMapProviderClassName = "com.google.gwt.thirdparty.common.css.compiler.gssfunctions.DefaultGssFunctionMapProvider";
        @Option(name="--css-renaming-prefix", usage="Add a prefix to all renamed css class names.")
        private String cssRenamingPrefix = "";
        @Argument
        private List<String> arguments = Lists.newArrayList();

        private Flags() {
        }

        private JobDescription createJobDescription() {
            JobDescriptionBuilder builder = new JobDescriptionBuilder();
            builder.setInputOrientation(this.inputOrientation);
            builder.setOutputOrientation(this.outputOrientation);
            builder.setOutputFormat(this.prettyPrint ? JobDescription.OutputFormat.PRETTY_PRINTED : JobDescription.OutputFormat.COMPRESSED);
            builder.setCopyrightNotice(this.copyrightNotice);
            builder.setTrueConditionNames(this.trueConditions);
            builder.setAllowUnrecognizedFunctions(this.allowUnrecognizedFunctions);
            builder.setAllowedNonStandardFunctions(this.allowedNonStandardFunctions);
            builder.setAllowedUnrecognizedProperties(this.allowedUnrecognizedProperties);
            builder.setAllowUnrecognizedProperties(this.allowUnrecognizedProperties);
            builder.setVendor(this.vendor);
            builder.setAllowKeyframes(true);
            builder.setAllowWebkitKeyframes(true);
            builder.setProcessDependencies(true);
            builder.setExcludedClassesFromRenaming(this.excludedClassesFromRenaming);
            builder.setSimplifyCss(true);
            builder.setEliminateDeadStyles(true);
            builder.setCssSubstitutionMapProvider(this.renamingType.getCssSubstitutionMapProvider());
            builder.setCssRenamingPrefix(this.cssRenamingPrefix);
            builder.setOutputRenamingMapFormat(this.outputRenamingMapFormat);
            GssFunctionMapProvider gssFunctionMapProvider = ClosureCommandLineCompiler.getGssFunctionMapProviderForName(this.gssFunctionMapProviderClassName);
            builder.setGssFunctionMapProvider(gssFunctionMapProvider);
            for (String fileName : this.arguments) {
                String fileContents;
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new RuntimeException(String.format("Input file %s does not exist", fileName));
                }
                try {
                    fileContents = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                builder.addInput(new SourceCode(fileName, fileContents));
            }
            return builder.getJobDescription();
        }

        private OutputInfo createOutputInfo() {
            return new OutputInfo(this.outputFile == null ? null : new File(this.outputFile), this.renameFile == null ? null : new File(this.renameFile));
        }
    }
}

