/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.commandline;

import com.google.gwt.thirdparty.common.css.AbstractCommandLineCompiler;
import com.google.gwt.thirdparty.common.css.ExitCodeHandler;
import com.google.gwt.thirdparty.common.css.JobDescription;
import com.google.gwt.thirdparty.common.css.RecordingSubstitutionMap;
import com.google.gwt.thirdparty.common.css.compiler.ast.BasicErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParser;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParserException;
import com.google.gwt.thirdparty.common.css.compiler.passes.CompactPrinter;
import com.google.gwt.thirdparty.common.css.compiler.passes.PassRunner;
import com.google.gwt.thirdparty.common.css.compiler.passes.PrettyPrinter;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultCommandLineCompiler
extends AbstractCommandLineCompiler {
    protected static final int MAXIMUM_ERRORS_TO_OUTPUT = 100;
    private CssTree cssTree;
    private final ErrorManager errorManager;
    private final PassRunner passRunner;

    protected DefaultCommandLineCompiler(JobDescription job, ExitCodeHandler exitCodeHandler, ErrorManager errorManager) {
        super(job, exitCodeHandler);
        this.errorManager = errorManager;
        this.passRunner = new PassRunner(job, errorManager);
    }

    public String compile() throws GssParserException {
        Preconditions.checkState((!this.compilerWasUsed ? 1 : 0) != 0);
        this.compilerWasUsed = true;
        int copyrightNoticeSize = this.job.copyrightNotice != null ? this.job.copyrightNotice.length() : 0;
        StringBuilder result = new StringBuilder(this.job.getAllInputsLength() + copyrightNoticeSize);
        if (this.job.copyrightNotice != null) {
            result.append(this.job.copyrightNotice);
        }
        GssParser parser2 = new GssParser(this.job.inputs);
        this.parseAndPrint(result, parser2);
        return result.toString();
    }

    private void parseAndPrint(StringBuilder result, GssParser parser2) throws GssParserException {
        this.cssTree = parser2.parse();
        if (this.job.outputFormat != JobDescription.OutputFormat.DEBUG) {
            this.passRunner.runPasses(this.cssTree);
        }
        if (this.job.outputFormat == JobDescription.OutputFormat.COMPRESSED) {
            CompactPrinter compactPrinterPass = new CompactPrinter(this.cssTree);
            compactPrinterPass.runPass();
            result.append(compactPrinterPass.getCompactPrintedString());
        } else {
            PrettyPrinter prettyPrinterPass = new PrettyPrinter(this.cssTree.getVisitController());
            prettyPrinterPass.runPass();
            result.append(prettyPrinterPass.getPrettyPrintedString());
        }
    }

    protected String execute(@Nullable File renameFile) {
        try {
            RecordingSubstitutionMap recordingSubstitutionMap;
            String compilerOutput = this.compile();
            this.errorManager.generateReport();
            if (this.errorManager.hasErrors()) {
                this.exitCodeHandler.processExitCode(1);
            }
            if ((recordingSubstitutionMap = this.passRunner.getRecordingSubstitutionMap()) != null && renameFile != null) {
                PrintWriter renamingMapWriter = new PrintWriter(Files.newWriter((File)renameFile, (Charset)StandardCharsets.UTF_8));
                Map<String, String> renamingMap = recordingSubstitutionMap.getMappings();
                this.writeRenamingMap(renamingMap, renamingMapWriter);
                renamingMapWriter.close();
            }
            return compilerOutput;
        }
        catch (IOException e) {
            AbstractCommandLineCompiler.exitOnUnhandledException(e, this.exitCodeHandler);
        }
        catch (GssParserException e) {
            System.err.println("Compiler parsing error: " + e.getMessage());
            e.printStackTrace();
            this.exitCodeHandler.processExitCode(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compiler internal error: " + e.getMessage());
            e.printStackTrace();
            this.exitCodeHandler.processExitCode(3);
        }
        return null;
    }

    protected void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
        this.job.outputRenamingMapFormat.writeRenamingMap(renamingMap, renamingMapWriter);
    }

    protected static final class CompilerErrorManager
    extends BasicErrorManager {
        private boolean warningsAsErrors = false;

        protected CompilerErrorManager() {
        }

        @Override
        public void print(String msg) {
            System.err.println(msg);
        }

        @Override
        public void reportWarning(GssError warning) {
            if (this.warningsAsErrors) {
                this.report(warning);
            } else {
                super.reportWarning(warning);
            }
        }

        public void setWarningsAsErrors(boolean state) {
            this.warningsAsErrors = state;
        }
    }
}

