/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.gssfunctions;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssHexColorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunction;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunctionException;
import com.google.gwt.thirdparty.common.css.compiler.gssfunctions.ColorParser;
import com.google.gwt.thirdparty.common.css.compiler.gssfunctions.ColorUtil;
import com.google.gwt.thirdparty.guava.common.base.CharMatcher;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class GssFunctions {
    private static final String DECIMAL_FORMAT = "#.########";

    public static Map<String, GssFunction> getFunctionMap() {
        return ImmutableMap.builder().put((Object)"add", (Object)new AddToNumericValue()).put((Object)"sub", (Object)new SubtractFromNumericValue()).put((Object)"mult", (Object)new Mult()).put((Object)"divide", (Object)new Div()).put((Object)"min", (Object)new MinValue()).put((Object)"max", (Object)new MaxValue()).put((Object)"blendColorsHsb", (Object)new BlendColorsHsb()).put((Object)"blendColorsRgb", (Object)new BlendColorsRgb()).put((Object)"makeMutedColor", (Object)new MakeMutedColor()).put((Object)"addHsbToCssColor", (Object)new AddHsbToCssColor()).put((Object)"makeContrastingColor", (Object)new MakeContrastingColor()).put((Object)"adjustBrightness", (Object)new AdjustBrightness()).put((Object)"makeTranslucent", (Object)new MakeTranslucent()).put((Object)"selectFrom", (Object)new SelectFrom()).build();
    }

    private static Color blendHsb(Color startColor, Color endColor) {
        float midHue;
        float[] startColorHsb = ColorUtil.toHsb(startColor);
        float[] endColorHsb = ColorUtil.toHsb(endColor);
        float diffHue = Math.abs(startColorHsb[0] - endColorHsb[0]);
        float sumHue = startColorHsb[0] + endColorHsb[0];
        float f = midHue = (double)diffHue <= 0.5 ? sumHue / 2.0f : (sumHue + 1.0f) / 2.0f;
        if (midHue > 1.0f) {
            midHue -= 1.0f;
        }
        return Color.getHSBColor(midHue, (startColorHsb[1] + endColorHsb[1]) / 2.0f, (startColorHsb[2] + endColorHsb[2]) / 2.0f);
    }

    public static boolean parseBoolean(String numericPart) {
        return Integer.parseInt(numericPart) == 1;
    }

    public static CssFunctionNode createUrlNode(String imageUrl, SourceCodeLocation location) {
        CssFunctionNode url = new CssFunctionNode(CssFunctionNode.Function.byName("url"), location);
        if (!imageUrl.equals("")) {
            CssLiteralNode argument = new CssLiteralNode(imageUrl, location);
            ImmutableList argList = ImmutableList.of((Object)argument);
            CssFunctionArgumentsNode arguments = new CssFunctionArgumentsNode((List<CssValueNode>)argList);
            url.setArguments(arguments);
        }
        return url;
    }

    public static GssFunctionException error(CssValueNode node, String errorMessage, ErrorManager errorManager) {
        return GssFunctions.error(errorMessage, errorManager, node.getSourceCodeLocation());
    }

    private static GssFunctionException error(String errorMessage, ErrorManager errorManager, SourceCodeLocation location) {
        if (errorManager != null) {
            errorManager.report(new GssError(errorMessage, location));
        }
        return new GssFunctionException(errorMessage);
    }

    private static CssNumericNode getSizeNode(CssValueNode valueNode, ErrorManager errorManager, boolean isUnitOptional) throws GssFunctionException {
        SourceCodeLocation location = valueNode.getSourceCodeLocation();
        if (valueNode instanceof CssNumericNode) {
            CssNumericNode node = (CssNumericNode)valueNode;
            GssFunctions.checkSize(node.getNumericPart(), node.getUnit(), errorManager, location, isUnitOptional);
            return node;
        }
        String message = "Size must be a CssNumericNode with a unit or 0; was: " + valueNode.toString();
        throw GssFunctions.error(message, errorManager, location);
    }

    private static void checkSize(String valueString, String unit, ErrorManager errorManager, SourceCodeLocation location, boolean isUnitOptional) throws GssFunctionException {
        Double value;
        if (unit.equals(CssNumericNode.NO_UNITS) && (value = Double.valueOf(Double.parseDouble(valueString))) != 0.0 && !isUnitOptional) {
            String message = "Size must be 0 or have a unit; was: " + valueString + unit;
            throw GssFunctions.error(message, errorManager, location);
        }
    }

    private static String getColorFromNode(CssValueNode arg, ErrorManager errorManager) throws GssFunctionException {
        if (arg instanceof CssHexColorNode) {
            return arg.getValue().substring(1);
        }
        if (arg instanceof CssLiteralNode) {
            return arg.getValue();
        }
        String message = "First argument must be a CssHexColorNode or LiteralNode containing a color name";
        throw GssFunctions.error(arg, message, errorManager);
    }

    private static String getColor(String color) {
        if (color.charAt(0) == '#') {
            return color.substring(1);
        }
        return color;
    }

    public static String createUrl(String url) {
        return CssFunctionNode.Function.byName("url") + "(" + url + ")";
    }

    private static Size parseSize(String sizeWithUnits, boolean isUnitOptional) throws GssFunctionException {
        int unitIndex = CharMatcher.JAVA_LETTER.indexIn((CharSequence)sizeWithUnits);
        String size = unitIndex > 0 ? sizeWithUnits.substring(0, unitIndex) : sizeWithUnits;
        String units = unitIndex > 0 ? sizeWithUnits.substring(unitIndex) : CssNumericNode.NO_UNITS;
        GssFunctions.checkSize(size, units, null, null, isUnitOptional);
        return new Size(size, units);
    }

    private static final class Size {
        final String size;
        final String units;

        public Size(String size, String units) {
            this.size = size;
            this.units = units;
        }
    }

    public static class SelectFrom
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 3;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            return ImmutableList.of((Object)("true".equals(args.get(0).getValue()) ? args.get(1) : args.get(2)));
        }

        @Override
        public String getCallResultString(List<String> args) {
            return "true".equals(args.get(0)) ? args.get(1) : args.get(2);
        }
    }

    public static class MakeTranslucent
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String color = arg1.getValue();
            String alpha = arg2.toString();
            return ImmutableList.of((Object)this.makeTranslucent(color, alpha, arg1.getSourceCodeLocation()));
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.makeTranslucent(args.get(0), args.get(1), null).getValue();
        }

        protected CssValueNode makeTranslucent(String inputColorStr, String alphaStr, @Nullable SourceCodeLocation sourceCodeLocation) {
            Color inputColor = ColorParser.parseAny(inputColorStr);
            double alpha = Math.min(1.0, (double)Math.max(0.0f, Float.parseFloat(alphaStr)));
            float[] rgb = inputColor.getRGBColorComponents(null);
            Color outputColor = new Color(rgb[0], rgb[1], rgb[2], (float)alpha);
            ImmutableList argList = ImmutableList.of((Object)new CssLiteralNode(Integer.toString(outputColor.getRed()), sourceCodeLocation), (Object)new CssLiteralNode(Integer.toString(outputColor.getGreen()), sourceCodeLocation), (Object)new CssLiteralNode(Integer.toString(outputColor.getBlue()), sourceCodeLocation), (Object)new CssLiteralNode(new DecimalFormat("#.###").format((float)outputColor.getAlpha() / 255.0f), sourceCodeLocation));
            CssCompositeValueNode argsValue = new CssCompositeValueNode((List<CssValueNode>)argList, CssCompositeValueNode.Operator.COMMA, sourceCodeLocation);
            CssFunctionNode result = new CssFunctionNode(CssFunctionNode.Function.byName("rgba"), sourceCodeLocation);
            result.setArguments(new CssFunctionArgumentsNode((List<CssValueNode>)ImmutableList.of((Object)argsValue)));
            return result;
        }
    }

    public static class MakeContrastingColor
    implements GssFunction {
        private static final int NUM_ITERATIONS = 8;

        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String color = arg1.getValue();
            String similarity = arg2.toString();
            String resultStr = this.makeContrastingColor(color, similarity);
            CssHexColorNode result = new CssHexColorNode(resultStr, arg1.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.makeContrastingColor(args.get(0), args.get(1));
        }

        protected String makeContrastingColor(String inputColorStr, String similarityStr) {
            if ("transparent".equalsIgnoreCase(inputColorStr)) {
                return inputColorStr;
            }
            Color inputColor = ColorParser.parseAny(inputColorStr);
            float similarity = Float.parseFloat(similarityStr);
            float[] distantColor = ColorUtil.toHsb(this.getDistantColor(inputColor, Color.BLACK, Color.WHITE));
            float[] startColor = ColorUtil.toHsb(inputColor);
            float[] endColor = distantColor;
            float[] closestContrastColor = null;
            for (int i = 0; i < 8; ++i) {
                closestContrastColor = this.blendSb(startColor, endColor, 0.5f);
                if (ColorUtil.testContrast(inputColor, ColorUtil.hsbToColor(closestContrastColor))) {
                    endColor = closestContrastColor;
                    continue;
                }
                startColor = closestContrastColor;
            }
            float[] resultColor = this.blendSb(closestContrastColor, distantColor, similarity);
            return ColorUtil.formatColor(ColorUtil.hsbToColor(resultColor));
        }

        private Color getDistantColor(Color color, Color first, Color second) {
            int secondLuminanceDiff;
            int firstLuminanceDiff = ColorUtil.luminanceDiff(color, first);
            return firstLuminanceDiff >= (secondLuminanceDiff = ColorUtil.luminanceDiff(color, second)) ? first : second;
        }

        private float[] blendSb(float[] keepHue, float[] other, float similarity) {
            float[] result = Arrays.copyOf(keepHue, keepHue.length);
            this.mix(1, keepHue, other, similarity, result);
            this.mix(2, keepHue, other, similarity, result);
            return result;
        }

        private void mix(int componentIdx, float[] sourceHsb, float[] otherColorHsb, float sourceSimilarity, float[] resultHsb) {
            resultHsb[componentIdx] = sourceHsb[componentIdx] * sourceSimilarity + otherColorHsb[componentIdx] * (1.0f - sourceSimilarity);
        }
    }

    public static class AdjustBrightness
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode originalColorNode = args.get(0);
            CssValueNode brightnessAmount = args.get(1);
            String originalColorStr = originalColorNode.getValue();
            String brightnessAmountStr = ((CssNumericNode)brightnessAmount).getNumericPart();
            String resultStr = this.adjustBrightness(originalColorStr, brightnessAmountStr);
            CssHexColorNode result = new CssHexColorNode(resultStr, originalColorNode.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        private float normalize(float value) {
            if ((double)value > 1.0) {
                return 1.0f;
            }
            if ((double)value < 0.0) {
                return 0.0f;
            }
            return value;
        }

        private String formatColorWithAdjustedBrightness(float[] originalHsb, float adjustedBrightness) {
            return ColorUtil.formatColor(Color.getHSBColor(originalHsb[0], originalHsb[1], adjustedBrightness));
        }

        protected String adjustBrightness(String originalColorStr, String brightnessStr) {
            if ("transparent".equalsIgnoreCase(originalColorStr)) {
                return originalColorStr;
            }
            Color originalColor = ColorParser.parseAny(originalColorStr);
            float brightnessFloat = Float.parseFloat(brightnessStr) / 100.0f;
            float[] originalColorHsb = ColorUtil.toHsb(originalColor);
            float requestedBrightness = originalColorHsb[2] + brightnessFloat;
            if ((double)requestedBrightness >= 0.0 && (double)requestedBrightness <= 1.0) {
                return this.formatColorWithAdjustedBrightness(originalColorHsb, requestedBrightness);
            }
            requestedBrightness = this.normalize(requestedBrightness);
            float oppositeDirectionBrightness = this.normalize(originalColorHsb[2] - brightnessFloat);
            float chosenBrightness = Math.abs(brightnessFloat - (originalColorHsb[2] - requestedBrightness)) > Math.abs(brightnessFloat - (originalColorHsb[2] - oppositeDirectionBrightness)) ? oppositeDirectionBrightness : requestedBrightness;
            return this.formatColorWithAdjustedBrightness(originalColorHsb, chosenBrightness);
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.adjustBrightness(args.get(0), args.get(1));
        }
    }

    public static class Div
    extends ScalarLeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left / right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 1.0;
        }
    }

    public static class Mult
    extends ScalarLeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left * right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 1.0;
        }
    }

    private static abstract class ScalarLeftAssociativeOperator
    extends LeftAssociativeOperator {
        private ScalarLeftAssociativeOperator() {
        }

        @Override
        protected CssNumericNode calculate(List<CssNumericNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.size() == 0) {
                throw GssFunctions.error("Not enough arguments", errorManager, args.get(0).getSourceCodeLocation());
            }
            double total = Double.valueOf(args.get(0).getNumericPart());
            String overallUnit = args.get(0).getUnit();
            for (CssNumericNode node : args.subList(1, args.size())) {
                if (node.getUnit() != null && !node.getUnit().equals(CssNumericNode.NO_UNITS)) {
                    throw GssFunctions.error("Only the first argument may have a unit associated with it,  but has unit: " + node.getUnit(), errorManager, node.getSourceCodeLocation());
                }
                double value = Double.valueOf(node.getNumericPart());
                total = this.performOperation(total, value);
            }
            String resultString = new DecimalFormat(GssFunctions.DECIMAL_FORMAT).format(total);
            return new CssNumericNode(resultString, overallUnit != null ? overallUnit : CssNumericNode.NO_UNITS, args.get(0).getSourceCodeLocation());
        }
    }

    public static class MinValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return Math.min(left, right);
        }
    }

    public static class MaxValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return Math.max(left, right);
        }
    }

    public static class SubtractFromNumericValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left - right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 0.0;
        }
    }

    public static class AddToNumericValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left + right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 0.0;
        }
    }

    private static abstract class LeftAssociativeOperator
    implements GssFunction {
        private LeftAssociativeOperator() {
        }

        @Override
        public Integer getNumExpectedArguments() {
            return null;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            ArrayList numericList = Lists.newArrayList();
            for (CssValueNode arg : args) {
                numericList.add(GssFunctions.getSizeNode(arg, errorManager, true));
            }
            return ImmutableList.of((Object)this.calculate(numericList, errorManager));
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            ArrayList numericList = Lists.newArrayList();
            for (String arg : args) {
                Size sizeWithUnits = GssFunctions.parseSize(arg, true);
                numericList.add(new CssNumericNode(sizeWithUnits.size, sizeWithUnits.units));
            }
            CssNumericNode result = this.calculate(numericList, null);
            return result.getNumericPart() + result.getUnit();
        }

        protected CssNumericNode calculate(List<CssNumericNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.size() < 2) {
                throw GssFunctions.error("Not enough arguments", errorManager, args.get(0).getSourceCodeLocation());
            }
            double total = Double.valueOf(args.get(0).getNumericPart());
            String overallUnit = this.isIdentityValue(total) ? null : args.get(0).getUnit();
            for (CssNumericNode node : args.subList(1, args.size())) {
                double value = Double.valueOf(node.getNumericPart());
                if (this.isIdentityValue(value)) continue;
                if (overallUnit == null) {
                    overallUnit = node.getUnit();
                } else if (!overallUnit.equals(node.getUnit())) {
                    throw GssFunctions.error("Parameters' units don't match (\"" + overallUnit + "\" vs \"" + node.getUnit() + "\")", errorManager, node.getSourceCodeLocation());
                }
                total = this.performOperation(total, value);
            }
            String resultString = new DecimalFormat(GssFunctions.DECIMAL_FORMAT).format(total);
            return new CssNumericNode(resultString, overallUnit != null ? overallUnit : CssNumericNode.NO_UNITS, args.get(0).getSourceCodeLocation());
        }

        protected abstract double performOperation(double var1, double var3);

        protected boolean isIdentityValue(double value) {
            return false;
        }
    }

    public static class MakeMutedColor
    implements GssFunction {
        private float LOSS_OF_SATURATION_FOR_MUTED_TONE = 0.2f;
        private String ARGUMENT_COUNT_ERROR_MESSAGE = "makeMutedColor expected arguments: backgroundColorStr, foregroundColorStr and an optional loss of saturation value (0 <= loss <= 1).";

        @Override
        public Integer getNumExpectedArguments() {
            return null;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.size() != 2 && args.size() != 3) {
                throw new GssFunctionException(this.ARGUMENT_COUNT_ERROR_MESSAGE);
            }
            CssValueNode backgroundColorNode = args.get(0);
            CssValueNode foregroundColorNode = args.get(1);
            String lossOfSaturationForMutedTone = String.valueOf(this.LOSS_OF_SATURATION_FOR_MUTED_TONE);
            if (args.size() == 3) {
                lossOfSaturationForMutedTone = args.get(2).getValue();
            }
            String backgroundColorStr = backgroundColorNode.getValue();
            String foregroundColorStr = foregroundColorNode.getValue();
            String resultStr = this.makeMutedColor(backgroundColorStr, foregroundColorStr, lossOfSaturationForMutedTone);
            CssHexColorNode result = new CssHexColorNode(resultStr, backgroundColorNode.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        protected String makeMutedColor(String backgroundColorStr, String foregroundColorStr, String lossStr) {
            if ("transparent".equalsIgnoreCase(backgroundColorStr) || "transparent".equalsIgnoreCase(foregroundColorStr)) {
                return foregroundColorStr;
            }
            Color backgroundColor = ColorParser.parseAny(backgroundColorStr);
            Color foregroundColor = ColorParser.parseAny(foregroundColorStr);
            float[] backgroundColorHsb = ColorUtil.toHsb(backgroundColor);
            float[] foregroundColorHsb = ColorUtil.toHsb(foregroundColor);
            float lossOfSaturationForMutedTone = Float.valueOf(lossStr).floatValue();
            if (lossOfSaturationForMutedTone < 0.0f) {
                lossOfSaturationForMutedTone = 0.0f;
            } else if (lossOfSaturationForMutedTone > 1.0f) {
                lossOfSaturationForMutedTone = 1.0f;
            }
            float mutedHue = foregroundColorHsb[0];
            float mutedSaturation = Math.max(foregroundColorHsb[1] - lossOfSaturationForMutedTone, 0.0f);
            float mutedBrightness = (foregroundColorHsb[2] + backgroundColorHsb[2]) / 2.0f;
            Color mutedColor = Color.getHSBColor(mutedHue, mutedSaturation, mutedBrightness);
            return ColorUtil.formatColor(mutedColor);
        }

        protected String makeMutedColor(String backgroundColorStr, String foregroundColorStr) {
            return this.makeMutedColor(backgroundColorStr, foregroundColorStr, String.valueOf(this.LOSS_OF_SATURATION_FOR_MUTED_TONE));
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            if (args.size() == 2) {
                return this.makeMutedColor(args.get(0), args.get(1));
            }
            if (args.size() == 3) {
                return this.makeMutedColor(args.get(0), args.get(1), args.get(2));
            }
            throw new GssFunctionException(this.ARGUMENT_COUNT_ERROR_MESSAGE);
        }
    }

    public static abstract class SemiTransparentBackgroundColor
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String color = GssFunctions.getColorFromNode(arg1, errorManager);
            String alphaChannel = arg2.toString();
            String urlArg = this.semiTransparentBackgroundUrl(color, alphaChannel);
            SourceCodeLocation location = arg1.getSourceCodeLocation();
            return ImmutableList.of((Object)GssFunctions.createUrlNode(urlArg, location));
        }

        @Override
        public String getCallResultString(List<String> args) {
            return GssFunctions.createUrl(this.semiTransparentBackgroundUrl(GssFunctions.getColor(args.get(0)), args.get(1)));
        }

        protected abstract String semiTransparentBackgroundUrl(String var1, String var2);
    }

    public static class AddHsbToCssColor
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 4;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            CssValueNode arg3 = args.get(2);
            CssValueNode arg4 = args.get(3);
            if (!(arg1 instanceof CssHexColorNode) && !(arg1 instanceof CssLiteralNode)) {
                String message = "The first argument must be a CssHexColorNode or a CssLiteralNode.";
                errorManager.report(new GssError(message, arg1.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            if (!(arg2 instanceof CssNumericNode && arg3 instanceof CssNumericNode && arg4 instanceof CssNumericNode)) {
                String message = "Arguments number 2, 3 and 4 must be CssNumericNodes";
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            CssNumericNode numeric3 = (CssNumericNode)arg3;
            CssNumericNode numeric4 = (CssNumericNode)arg4;
            try {
                String resultString = this.addHsbToCssColor(args.get(0).getValue(), numeric2.getNumericPart(), numeric3.getNumericPart(), numeric4.getNumericPart());
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHsbToCssColor(baseColorString, args.get(1), args.get(2), args.get(3));
        }

        protected String addHsbToCssColor(String baseColorString, String hueToAdd, String saturationToAdd, String brightnessToAdd) throws GssFunctionException {
            try {
                return this.addHsbToCssColor(baseColorString, Integer.parseInt(hueToAdd), Integer.parseInt(saturationToAdd), Integer.parseInt(brightnessToAdd));
            }
            catch (NumberFormatException e) {
                String message = String.format("Could not parse the integer arguments for the function 'addHsbToCssColor'. The list of arguments was: %s, %s, %s, %s. ", baseColorString, hueToAdd, saturationToAdd, brightnessToAdd);
                throw new GssFunctionException(message);
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Could not parse the color argument for the function 'addHsbToCssColor'. The list of arguments was: %s, %s, %s, %s. ", baseColorString, hueToAdd, saturationToAdd, brightnessToAdd);
                throw new GssFunctionException(message);
            }
        }

        public String addHsbToCssColor(String baseColorString, int hueToAdd, int saturationToAdd, int brightnessToAdd) {
            if ("transparent".equals(baseColorString)) {
                return baseColorString;
            }
            Color baseColor = ColorParser.parseAny(baseColorString);
            Color newColor = this.addValuesToHsbComponents(baseColor, hueToAdd, saturationToAdd, brightnessToAdd);
            return ColorUtil.formatColor(newColor);
        }

        public Color addValuesToHsbComponents(Color baseColor, int hueToAdd, int saturationToAdd, int brightnessToAdd) {
            float[] hsbValues = ColorUtil.toHsb(baseColor);
            hsbValues[0] = (float)((double)hsbValues[0] + (double)hueToAdd / 360.0);
            hsbValues[0] = hsbValues[0] - (float)Math.floor(hsbValues[0]);
            hsbValues[1] = (float)Math.min(1.0, Math.max(0.0, (double)hsbValues[1] + (double)saturationToAdd / 100.0));
            hsbValues[2] = (float)Math.min(1.0, Math.max(0.0, (double)hsbValues[2] + (double)brightnessToAdd / 100.0));
            return Color.getHSBColor(hsbValues[0], hsbValues[1], hsbValues[2]);
        }
    }

    public static class BlendColorsRgb
    extends BaseBlendColors {
        @Override
        public String blend(String startColorStr, String endColorStr) {
            Color startColor = ColorParser.parseAny(startColorStr);
            Color endColor = ColorParser.parseAny(endColorStr);
            Color midColor = new Color((startColor.getRed() + endColor.getRed()) / 2, (startColor.getGreen() + endColor.getGreen()) / 2, (startColor.getBlue() + endColor.getBlue()) / 2);
            return ColorUtil.formatColor(midColor);
        }
    }

    public static class BlendColorsHsb
    extends BaseBlendColors {
        @Override
        public String blend(String startColorStr, String endColorStr) {
            Color midColor = GssFunctions.blendHsb(ColorParser.parseAny(startColorStr), ColorParser.parseAny(endColorStr));
            return ColorUtil.formatColor(midColor);
        }
    }

    public static abstract class BaseBlendColors
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String startColorStr = arg1.getValue();
            String endColorStr = arg2.getValue();
            String resultString = this.blend(startColorStr, endColorStr);
            CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            try {
                return this.blend(args.get(0), args.get(1));
            }
            catch (IllegalArgumentException e) {
                throw new GssFunctionException("Colors could not be parsed", e);
            }
        }

        public abstract String blend(String var1, String var2);
    }

    static class ImageBackground {
        private static final String NO_REPEAT = "no-repeat";
        private final String url;
        private final String positionH;
        private final String positionHUnit;
        private final String positionV;
        private final String positionVUnit;

        public ImageBackground(String url, String cornerId, String imgSize, String units) {
            this.url = url;
            boolean isZero = Float.parseFloat(imgSize) == 0.0f;
            boolean isLeft = isZero || cornerId.endsWith("l");
            this.positionH = isLeft ? "0" : "-" + imgSize;
            this.positionHUnit = isLeft ? CssNumericNode.NO_UNITS : units;
            boolean isTop = isZero || cornerId.startsWith("t");
            this.positionV = isTop ? "0" : "-" + imgSize;
            this.positionVUnit = isTop ? CssNumericNode.NO_UNITS : units;
        }

        public String toString() {
            return GssFunctions.createUrl(this.url) + " " + NO_REPEAT + " " + this.positionH + this.positionHUnit + " " + this.positionV + this.positionVUnit;
        }

        public List<CssValueNode> toNodes(SourceCodeLocation location) {
            return ImmutableList.of((Object)GssFunctions.createUrlNode(this.url, location), (Object)new CssLiteralNode(NO_REPEAT, location), (Object)new CssNumericNode(this.positionH, this.positionHUnit, location), (Object)new CssNumericNode(this.positionV, this.positionVUnit, location));
        }
    }
}

