/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssHexColorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.Property;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class AbbreviatePositionalValues
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;

    public AbbreviatePositionalValues(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        CssPropertyValueNode valueNode;
        List<CssValueNode> newValues;
        Property property = declaration.getPropertyName().getProperty();
        if (property.hasPositionalParameters() && (newValues = this.abbreviateValues((valueNode = declaration.getPropertyValue()).getChildren())) != null) {
            CssDeclarationNode newDeclaration = new CssDeclarationNode(declaration);
            CssPropertyValueNode newValuesNode = new CssPropertyValueNode(newValues);
            newDeclaration.setPropertyValue(newValuesNode);
            ArrayList replacementList = Lists.newArrayList();
            replacementList.add(newDeclaration);
            this.visitController.replaceCurrentBlockChildWith(replacementList, false);
        }
        return true;
    }

    private List<CssValueNode> abbreviateValues(List<CssValueNode> values) {
        int numValues = values.size();
        if (numValues <= 1 || numValues > 4) {
            return null;
        }
        ArrayList mutableList = Lists.newArrayList(values);
        if (numValues == 4 && AbbreviatePositionalValues.equalValues(values.get(3), values.get(1))) {
            --numValues;
            mutableList.remove(3);
        }
        if (numValues == 3 && AbbreviatePositionalValues.equalValues(values.get(2), values.get(0))) {
            --numValues;
            mutableList.remove(2);
        }
        if (numValues == 2 && AbbreviatePositionalValues.equalValues(values.get(1), values.get(0))) {
            --numValues;
            mutableList.remove(1);
        }
        return numValues != values.size() ? mutableList : null;
    }

    @VisibleForTesting
    static boolean equalValues(CssValueNode v1, CssValueNode v2) {
        if (v1.equals(v2)) {
            return true;
        }
        if (v1 instanceof CssNumericNode && v2 instanceof CssNumericNode) {
            CssNumericNode numeric1 = (CssNumericNode)v1;
            CssNumericNode numeric2 = (CssNumericNode)v2;
            return numeric1.getNumericPart().equals(numeric2.getNumericPart()) && numeric1.getUnit().equals(numeric2.getUnit());
        }
        if (v1 instanceof CssLiteralNode && v2 instanceof CssLiteralNode) {
            return v1.getValue().equals(v2.getValue());
        }
        if (v1 instanceof CssHexColorNode && v2 instanceof CssHexColorNode) {
            CssHexColorNode hex1 = (CssHexColorNode)v1;
            CssHexColorNode hex2 = (CssHexColorNode)v2;
            return hex1.toString().equals(hex2.toString());
        }
        return false;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

